package Korjaaja;
import robocode.*;
import java.awt.Color;
import java.util.*;

/**
 * Korjaaja - a robot by (Petri Sandström)
 */
public class Korjaaja extends Robot
{
	
	private boolean direction;
	private int counter;
	private double distance;

	private String targetName;
	private int targetNameCounter;
	
	private boolean sameTarget;

	/**
	 * run: Korjaaja's default behavior
	 */
	public void run() {
	
		// Set colors
		setBodyColor(new Color(0, 0, 0));
		setGunColor(new Color(0, 0, 0));
		setRadarColor(new Color(0, 0, 0));
		setBulletColor(new Color(255, 255, 255));
		setScanColor(new Color(0, 0, 0));	

		
		ahead(250);
		
		// Robot main loop
		while(true) {
			
			if (sameTarget) turnGunRight(220);
			turnGunRight(90);
			back(180-(distance/10));
			turnGunRight(90);
			ahead(180-(distance/10));
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		// Replace the next line with any behavior you would like
		if (e.getDistance()>150)fire(1);
		else if (e.getDistance()>100)fire(2);
		else if (e.getDistance()>50)fire(3);
		else fire(4);
		distance = e.getDistance();

		if (targetName == e.getName())
		{
			targetNameCounter++;
		} else {
			targetNameCounter = 0;
			targetName = e.getName();
		}
		
		sameTarget = targetNameCounter > 10;

	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		// Replace the next line with any behavior you would like
		//turnRight(new Random().nextInt(180));
		//fire(1);
		turnRight(new Random().nextInt(70)+50);
		ahead(200);
		//turnGunRight(90);
        //turnGunRight(180);
			
	}
	
	/**
	 * onHitWall: What to do when you hit a wall
	 */
	public void onHitWall(HitWallEvent e) {
		// Replace the next line with any behavior you would like
		
		direction = !direction;
		if (counter++>1)
		{
			counter = 0;
		}	
		if (direction) {
		    //ahead(100);
			back(100);
			turnRight(90);
		    ahead(100);
			//turnGunRight(180);
		} else {
			//back(100);
		    ahead(100);
			turnRight(90);
			back(100);
			//turnGunRight(180);
		}
	}	
}
																							