function initGL(){
try {

var scrWidth, scrHeight
if (self.innerWidth) {
scrWidth = self.innerWidth;
scrHeight = self.innerHeight;
} else if (document.documentElement && (document.documentElement.clientWidth || document.documentElement.clientHeight)) {
scrWidth = document.documentElement.clientWidth;
scrHeight = document.documentElement.clientHeight;
} else if (document.body) {
scrWidth = document.body.clientWidth;
scrHeight = document.body.clientHeight;
}
canvas.width= document.body.clientWidth*0.99;
canvas.height = canvas.width*(9/16)-16;
gl.viewportWidth=canvas.width;
gl.viewportHeight=canvas.height;
resolution_x=gl.viewportWidth;
resolution_y=gl.viewportHeight;
canvas.style.position = "absolute";
canvas.style.top = ""+Math.ceil((window.innerHeight - canvas.height) / 2) + "px";
} catch (e){
}
if (!gl){
alert("Could not initialise WebGL, sorry :-(");
}
}

function getShader(id){
var shaderScript=document.getElementById(id);
if (!shaderScript){
return null;
}
var str="";
var k=shaderScript.firstChild;
while (k){
if (k.nodeType == 3){
str += k.textContent;
}
k=k.nextSibling;
}

var shader;
if (shaderScript.type == "x-shader/x-fragment"){
shader=gl.createShader(gl.FRAGMENT_SHADER);
} else if (shaderScript.type == "x-shader/x-vertex"){
shader=gl.createShader(gl.VERTEX_SHADER);
} else {
return null;
}

gl.shaderSource(shader, str);
gl.compileShader(shader);

if (!gl.getShaderParameter(shader, gl.COMPILE_STATUS)){
alert(gl.getShaderInfoLog(shader));
return null;
}
return shader;
}
function initShaders(){
var fragmentShader=getShader("shader-fs");
var vertexShader=getShader("shader-vs");
shaderProgram=gl.createProgram();
gl.attachShader(shaderProgram, vertexShader);
gl.attachShader(shaderProgram, fragmentShader);
gl.linkProgram(shaderProgram);
if (!gl.getProgramParameter(shaderProgram, gl.LINK_STATUS)){
alert("Could not initialise shaders");
}
gl.useProgram(shaderProgram);

shaderProgram.vertexPositionAttribute=gl.getAttribLocation(shaderProgram, "aVertexPosition");
gl.enableVertexAttribArray(shaderProgram.vertexPositionAttribute);
shaderProgram.vertexColorAttribute=gl.getAttribLocation(shaderProgram, "aVertexColor");
gl.enableVertexAttribArray(shaderProgram.vertexColorAttribute);
shaderProgram.pMatrixUniform=gl.getUniformLocation(shaderProgram, "uPMat");
shaderProgram.mvMatrixUniform=gl.getUniformLocation(shaderProgram, "uMVMat");
shaderProgram.resolutionUniform=gl.getUniformLocation(shaderProgram, "resolution");
shaderProgram.randomseedUniform=gl.getUniformLocation(shaderProgram, "randomseed");
}

function setMatrixUniforms(){
gl.uniformMatrix4fv(shaderProgram.pMatrixUniform, false, pMat);
gl.uniformMatrix4fv(shaderProgram.mvMatrixUniform, false, mvMat);
gl.uniform2f(shaderProgram.resolutionUniform,resolution_x,resolution_y);
gl.uniform2f(shaderProgram.randomseedUniform,Math.random(),Math.random());
}
