#define GL_GLEXT_PROTOTYPES
#include <GL/gl.h>
#include <math.h>
#include "matrix.h"
#include "pdb.h"
#include "molscene.h"
#include "shader.h"
#include "sky.h"

PDB pyrococcus;
PDB dengue;
PDB mouth;

GLuint mol_shaders[3];
GLuint mol_prg;

float *perspective;

void initMolScene(float *pmatrix){

   perspective = pmatrix;

   /* PDB models from pdb.org (Protein Data Bank) */
   loadPDB(&pyrococcus, "data/2E0Z.pdb");
   generateMesh(&pyrococcus);
   loadPDB(&dengue, "data/4B03.pdb");
   generateMesh(&dengue);
   loadPDB(&mouth, "data/4GH4.pdb");
   generateMesh(&mouth);

   /* Load some shaders */
   mol_shaders[0] = loadShader(GL_GEOMETRY_SHADER, "shaders/mol.gs");
   mol_shaders[1] = loadShader(GL_VERTEX_SHADER,   "shaders/mol.vs");
   mol_shaders[2] = loadShader(GL_FRAGMENT_SHADER, "shaders/mol.fs");
   mol_prg = createProgram(3, mol_shaders);

   /* Connect shader variables to buffer */
   glBindVertexArray(pyrococcus.vao);
   bindVarToBuff(mol_prg, "vertex", pyrococcus.vbo[0], 3);
   bindVarToBuff(mol_prg, "normal", pyrococcus.vbo[1], 3);

   glBindVertexArray(dengue.vao);
   bindVarToBuff(mol_prg, "vertex", dengue.vbo[0], 3);
   bindVarToBuff(mol_prg, "normal", dengue.vbo[1], 3);

   glBindVertexArray(mouth.vao);
   bindVarToBuff(mol_prg, "vertex", mouth.vbo[0], 3);
   bindVarToBuff(mol_prg, "normal", mouth.vbo[1], 3);

}

void molScene(double time){
   float pos[3], target[3], up[] = {0.0, 0.0, 1.0};
   float camera[16];
   GLint loc;

   pos[0] = -100.0; pos[1] = 0.0; pos[2] = -100.0;
   target[0] = 0.0;
   target[1] = 0.0;
   target[2] = 0.0;

   lookAt(camera, pos, target, up);

   glUseProgram(mol_prg);

   loc = glGetUniformLocation(mol_prg, "pmatrix");
   glUniformMatrix4fv(loc, 1, GL_FALSE, perspective);
   loc = glGetUniformLocation(mol_prg, "camera");
   glUniformMatrix4fv(loc, 1, GL_FALSE, camera);
   loc = glGetUniformLocation(mol_prg, "time");
   glUniform1f(loc, time);
   loc = glGetUniformLocation(mol_prg, "type");

   glUniform1i(loc, 1);
   drawPDB(pyrococcus);
   glUniform1i(loc, 2);
   drawPDB(dengue);
   glUniform1i(loc, 3);
   drawPDB(mouth);

   drawSky(perspective, camera, 3.0);
}

void freeMolScene(){
   freePDB(&pyrococcus);
   freePDB(&dengue);
   freePDB(&mouth);
   deleteProgram(mol_prg, 3, mol_shaders);
}
