#define GL_GLEXT_PROTOTYPES
#include <GL/gl.h>
#include <math.h>
#include "mesh3d.h"
#include "shader.h"
#include "antscene.h"
#include "matrix.h"
#include "texture.h"
#include "sky.h"

Mesh3D *ant;
Mesh3D *plant;
Mesh3D *ground;

float camera[16];
float *perspective;

GLuint antshaders[3];
GLuint antprg;

GLuint anttext;
GLuint groundtext;
GLuint nightskytext;
GLuint grasstext;

void initAntScene(float *pmatrix){

   /* Choose polygones ... */
   ant           = loadOBJ("data/ant.obj");
   plant         = loadOBJ("data/plant.obj");
   ground        = loadOBJ("data/ground.obj");

   perspective   = pmatrix;

   /* ... and shaders */
   antshaders[0] = loadShader(GL_VERTEX_SHADER, "shaders/ant.vs");
   antshaders[1] = loadShader(GL_FRAGMENT_SHADER, "shaders/ant.fs");
   antshaders[2] = loadShader(GL_GEOMETRY_SHADER, "shaders/ant.gs");
   antprg        = createProgram(3, antshaders);

   glBindVertexArray(ant->vao);
   bindVarToBuff(antprg, "vertex", ant->vbo[MESHVERTEXINDEX], 3);
   bindVarToBuff(antprg, "normal", ant->vbo[MESHNORMALINDEX], 3);
   bindVarToBuff(antprg, "textcoord", ant->vbo[MESHTEXINDEX], 2);

   glBindVertexArray(plant->vao);
   bindVarToBuff(antprg, "vertex", plant->vbo[MESHVERTEXINDEX], 3);
   bindVarToBuff(antprg, "normal", plant->vbo[MESHNORMALINDEX], 3);
   bindVarToBuff(antprg, "textcoord", plant->vbo[MESHTEXINDEX], 2);

   glBindVertexArray(ground->vao);
   bindVarToBuff(antprg, "vertex", ground->vbo[MESHVERTEXINDEX], 3);
   bindVarToBuff(antprg, "normal", ground->vbo[MESHNORMALINDEX], 3);
   bindVarToBuff(antprg, "textcoord", ground->vbo[MESHTEXINDEX], 2);
   
   /* textures */
   anttext       = loadPNGTexture("data/texture/hangya_textura.png");
   groundtext    = loadPNGTexture("data/texture/foldkep.png");
   nightskytext  = loadPNGTexture("data/texture/night_sky.png");
   grasstext     = loadPNGTexture("data/texture/fu_textura.png");
}

/* Draw plant, ant, sky, ground only the camera position is changing */
void commonDraw(){
   GLint loc;
   GLint clone;

   glUseProgram(antprg);

   loc = glGetUniformLocation(antprg, "pmatrix");
   glUniformMatrix4fv(loc, 1, GL_FALSE, perspective);
   loc = glGetUniformLocation(antprg, "camera");
   glUniformMatrix4fv(loc, 1, GL_FALSE, camera);
   loc = glGetUniformLocation(antprg, "tex");
   clone = glGetUniformLocation(antprg, "clone");

   glActiveTexture(GL_TEXTURE0);
   glBindTexture(GL_TEXTURE_2D, anttext);
   glUniform1i(loc, 0);
   glUniform1i(clone, 0);

   drawMesh3D(ant);
   glBindTexture(GL_TEXTURE_2D, grasstext);
   glUniform1i(clone,1);
   drawMesh3D(plant);
   drawSky(perspective, camera, 1.0);

   glBindTexture(GL_TEXTURE_2D, groundtext);
   glUniform1i(clone, 0);
   drawMesh3D(ground);
}

void antScene(double time){
   float pos[3];
   float target[] = {0.0769, 4.863, 16.9051};
   float up[] = {0.0, 0.0, 1.0};
   float percent;


   if(time < 7.40){
      pos[0] = 0.29076; pos[1] = 0.673; pos[2] = 22.04142;
   }
   else if(time >  7.40 && time < 15.10){
      pos[0] = 0.74392; pos[1] = 6.82751; pos[2] = 19.259;
   }
   else if(time > 15.10 && time < 22.43){
      pos[0] = -2.0; pos[1] = 4.863; pos[2] = 22.0;
   }
   else if(time > 22.43 && time < 30.52){
      pos[0] = 2.0; pos[1] = 4.863; pos[2] = 22.0;
   }
   else if(time > 30.52 && time < 38.00){
      /* See the sky */
      pos[0] = 0.29076;
      pos[1] = 0.673;
      pos[2] = 21.04142 - (time - 30.52) / 1.5;
   }
   else if(time > 38.00 && time < 45.50){
      pos[0] = target[0] + sin(time / 3.0) * (2.045 - target[0]);
      pos[1] = target[1] + cos(time / 3.0) * (2.5752 - target[1]);
      pos[2] = 18.027;
   }
   else if(time > 45.50 && time < 52.86){
      pos[0] = 0.29076;
      pos[1] = -2.673 + time - 46.5;
      pos[2] = 17.0;
      perspectiveMatrix(perspective, 35.0 + (time - 46.5) * 10.0, 1.7777, 0.1, 1500.0);
   }
   else{
      perspectiveMatrix(perspective, 35.0, 1.7777, 0.1, 1500.0);
      /* zoom to ant */
      percent = ((time - 54.86) / (60.0 - 52.86));
      pos[0] = 0.74392 + (target[0] - 0.74392) * percent;
      pos[1] = 6.82751 + (target[1] - 6.82751) * percent;
      pos[2] = 19.2590 + (target[2] - 19.2590) * percent;
   }

   lookAt(camera, pos, target, up);
   commonDraw();
}

void freeAntScene(){
   freeMesh3D(ant);
   freeMesh3D(plant);
   freeMesh3D(ground);
   deleteProgram(antprg, 2, antshaders);
}
