#version 150

in vec3 vertex;
in vec2 tcoord;

uniform mat4 pmatrix;
uniform mat4 camera;
out vec2 texc;
out float dist;

void main(void){
   vec3 pos = vertex - vec3(-2.0, 0.0, 2.0);
   gl_Position = pmatrix * camera * vec4(pos, 1.0);
   texc = tcoord;
   dist = distance(vertex, vec3(0.0,0.0,0.0)) / 10.0 + 0.5;
}
