uniform sampler2D groundtexture;

varying float cameraDistance;
varying vec2 texturecoord;

uniform float fogstart;
uniform float fogend;

void main(void)
{	
	float foglerp = 0.0;
	if (cameraDistance < fogstart)
	{
	}
	else if (cameraDistance > fogstart && cameraDistance < fogend)
	{
		foglerp = (cameraDistance - fogstart) / (fogend - fogstart);
	}
	else
	{
		foglerp = 1.0;
	}
	
//	foglerp = exp(foglerp, 0.1);
	
	vec4 texel = texture2D(groundtexture, texturecoord);
	gl_FragColor = texel * (1.0 - foglerp);
}