/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.jawt;

import com.jogamp.common.os.Platform;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.common.util.locks.LockFactory;
import com.jogamp.common.util.locks.RecursiveLock;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Map;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.ToolkitLock;
import jogamp.nativewindow.Debug;
import jogamp.nativewindow.jawt.JAWT;
import jogamp.nativewindow.jawt.JAWTJNILibLoader;

public class JAWTUtil {
    public static final boolean DEBUG = Debug.debug("JAWT");
    public static final int JAWT_MACOSX_USE_CALAYER = Integer.MIN_VALUE;
    public static final VersionNumber JAWT_MacOSXCALayerMinVersion = new VersionNumber(10, 6, 4);
    public static final VersionNumber JAWT_MacOSXCALayerRequiredForJavaVersion = new VersionNumber(1, 7, 0);
    private static final boolean headlessMode;
    private static final JAWT jawtLockObject;
    private static final Method isQueueFlusherThread;
    private static final boolean j2dExist;
    private static final Method sunToolkitAWTLockMethod;
    private static final Method sunToolkitAWTUnlockMethod;
    private static final boolean hasSunToolkitAWTLock;
    private static final RecursiveLock jawtLock;
    private static final ToolkitLock jawtToolkitLock;

    public static boolean isOffscreenLayerSupported() {
        return Platform.OS_TYPE == Platform.OSType.MACOS && Platform.OS_VERSION_NUMBER.compareTo(JAWT_MacOSXCALayerMinVersion) >= 0;
    }

    public static boolean isOffscreenLayerRequired() {
        return Platform.OS_TYPE == Platform.OSType.MACOS && Platform.JAVA_VERSION_NUMBER.compareTo(JAWT_MacOSXCALayerRequiredForJavaVersion) >= 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JAWT getJAWT(boolean bl) {
        boolean bl2;
        boolean bl3;
        JAWT jAWT = JAWT.create();
        int n = 65540;
        if (JAWTUtil.isOffscreenLayerRequired()) {
            if (Platform.OS_TYPE != Platform.OSType.MACOS) throw new InternalError("offscreen required, but n/a for: " + Platform.OS_TYPE);
            if (Platform.OS_VERSION_NUMBER.compareTo(JAWT_MacOSXCALayerMinVersion) < 0) throw new RuntimeException("OSX: Invalid version of Java (" + Platform.JAVA_VERSION_NUMBER + ") / OS X (" + Platform.OS_VERSION_NUMBER + ")");
            n |= Integer.MIN_VALUE;
            bl3 = true;
            bl2 = false;
        } else if (bl && JAWTUtil.isOffscreenLayerSupported()) {
            if (Platform.OS_TYPE != Platform.OSType.MACOS) throw new InternalError("offscreen requested and supported, but n/a for: " + Platform.OS_TYPE);
            n |= Integer.MIN_VALUE;
            bl3 = true;
            bl2 = true;
        } else {
            bl3 = false;
            bl2 = true;
        }
        if (DEBUG) {
            System.err.println("JAWTUtil.getJAWT(tryOffscreenLayer " + bl3 + ", tryOnscreen " + bl2 + ")");
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (bl3) {
            stringBuilder.append("Offscreen 0x").append(Integer.toHexString(n));
            if (JAWT.getJAWT(jAWT, n)) {
                return jAWT;
            }
        }
        if (!bl2) throw new RuntimeException("Unable to initialize JAWT, trials: " + stringBuilder.toString());
        if (bl3) {
            stringBuilder.append(", ");
        }
        stringBuilder.append("Onscreen 0x").append(Integer.toHexString(65540));
        if (!JAWT.getJAWT(jAWT, 65540)) throw new RuntimeException("Unable to initialize JAWT, trials: " + stringBuilder.toString());
        return jAWT;
    }

    public static boolean isJAWTUsingOffscreenLayer(JAWT jAWT) {
        return 0 != (jAWT.getCachedVersion() & Integer.MIN_VALUE);
    }

    public static void initSingleton() {
    }

    public static void shutdown() {
    }

    public static boolean hasJava2D() {
        return j2dExist;
    }

    public static boolean isJava2DQueueFlusherThread() {
        boolean bl = false;
        if (j2dExist) {
            try {
                bl = (Boolean)isQueueFlusherThread.invoke(null, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    public static boolean isHeadlessMode() {
        return headlessMode;
    }

    public static void lockToolkit() throws NativeWindowException {
        jawtLock.lock();
        if (1 == jawtLock.getHoldCount() && !headlessMode && !JAWTUtil.isJava2DQueueFlusherThread()) {
            if (hasSunToolkitAWTLock) {
                try {
                    sunToolkitAWTLockMethod.invoke(null, (Object[])null);
                }
                catch (Exception exception) {
                    throw new NativeWindowException("SunToolkit.awtLock failed", exception);
                }
            } else {
                jawtLockObject.Lock();
            }
        }
        if (ToolkitLock.TRACE_LOCK) {
            System.err.println("JAWTUtil-ToolkitLock.lock(): " + jawtLock);
        }
    }

    public static void unlockToolkit() {
        jawtLock.validateLocked();
        if (ToolkitLock.TRACE_LOCK) {
            System.err.println("JAWTUtil-ToolkitLock.unlock(): " + jawtLock);
        }
        if (1 == jawtLock.getHoldCount() && !headlessMode && !JAWTUtil.isJava2DQueueFlusherThread()) {
            if (hasSunToolkitAWTLock) {
                try {
                    sunToolkitAWTUnlockMethod.invoke(null, (Object[])null);
                }
                catch (Exception exception) {
                    throw new NativeWindowException("SunToolkit.awtUnlock failed", exception);
                }
            } else {
                jawtLockObject.Unlock();
            }
        }
        jawtLock.unlock();
    }

    public static final void validateLocked() throws RuntimeException {
        jawtLock.validateLocked();
    }

    public static ToolkitLock getJAWTToolkitLock() {
        return jawtToolkitLock;
    }

    static {
        if (DEBUG) {
            System.err.println("JAWTUtil initialization (JAWT/JNI/...");
        }
        JAWTJNILibLoader.initSingleton();
        if (!JAWTJNILibLoader.loadNativeWindow("awt")) {
            throw new NativeWindowException("NativeWindow AWT native library load error.");
        }
        headlessMode = GraphicsEnvironment.isHeadless();
        boolean bl = false;
        Class<?> clazz = null;
        Method method = null;
        if (!headlessMode) {
            jawtLockObject = JAWTUtil.getJAWT(false);
            try {
                clazz = Class.forName("jogamp.opengl.awt.Java2D");
                method = clazz.getMethod("isQueueFlusherThread", null);
                bl = true;
            }
            catch (Exception exception) {}
        } else {
            jawtLockObject = null;
        }
        isQueueFlusherThread = method;
        j2dExist = bl;
        PrivilegedDataBlob1 privilegedDataBlob1 = (PrivilegedDataBlob1)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                PrivilegedDataBlob1 privilegedDataBlob1 = new PrivilegedDataBlob1();
                try {
                    Class<?> clazz = Class.forName("sun.awt.SunToolkit");
                    privilegedDataBlob1.sunToolkitAWTLockMethod = clazz.getDeclaredMethod("awtLock", new Class[0]);
                    privilegedDataBlob1.sunToolkitAWTLockMethod.setAccessible(true);
                    privilegedDataBlob1.sunToolkitAWTUnlockMethod = clazz.getDeclaredMethod("awtUnlock", new Class[0]);
                    privilegedDataBlob1.sunToolkitAWTUnlockMethod.setAccessible(true);
                    privilegedDataBlob1.ok = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return privilegedDataBlob1;
            }
        });
        sunToolkitAWTLockMethod = privilegedDataBlob1.sunToolkitAWTLockMethod;
        sunToolkitAWTUnlockMethod = privilegedDataBlob1.sunToolkitAWTUnlockMethod;
        boolean bl2 = false;
        if (privilegedDataBlob1.ok) {
            try {
                sunToolkitAWTLockMethod.invoke(null, (Object[])null);
                sunToolkitAWTUnlockMethod.invoke(null, (Object[])null);
                bl2 = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        hasSunToolkitAWTLock = bl2;
        jawtLock = LockFactory.createRecursiveLock();
        jawtToolkitLock = new ToolkitLock(){

            @Override
            public final void lock() {
                JAWTUtil.lockToolkit();
            }

            @Override
            public final void unlock() {
                JAWTUtil.unlockToolkit();
            }

            @Override
            public final void validateLocked() throws RuntimeException {
                JAWTUtil.validateLocked();
            }

            @Override
            public final void dispose() {
            }

            public String toString() {
                return "JAWTToolkitLock[obj 0x" + Integer.toHexString(this.hashCode()) + ", isOwner " + jawtLock.isOwner(Thread.currentThread()) + ", " + jawtLock + "]";
            }
        };
        Map map = null;
        try {
            if (EventQueue.isDispatchThread()) {
                map = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
            } else {
                final ArrayList arrayList = new ArrayList(1);
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        Map map = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
                        if (null != map) {
                            arrayList.add(map);
                        }
                    }
                });
                map = arrayList.size() > 0 ? (Map)arrayList.get(0) : null;
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        if (DEBUG) {
            System.err.println("JAWTUtil: Has sun.awt.SunToolkit.awtLock/awtUnlock " + hasSunToolkitAWTLock);
            System.err.println("JAWTUtil: Has Java2D " + j2dExist);
            System.err.println("JAWTUtil: Is headless " + headlessMode);
            int n = null != map ? map.size() : 0;
            System.err.println("JAWTUtil: AWT Desktop hints " + n);
            System.err.println("JAWTUtil: OffscreenLayer Supported: " + JAWTUtil.isOffscreenLayerSupported() + " - Required " + JAWTUtil.isOffscreenLayerRequired());
        }
    }

    private static class PrivilegedDataBlob1 {
        Method sunToolkitAWTLockMethod;
        Method sunToolkitAWTUnlockMethod;
        boolean ok = false;

        PrivilegedDataBlob1() {
        }
    }
}

