/*
 * Decompiled with CFR 0.152.
 */
package processing.data;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import processing.core.PApplet;
import processing.data.IntDict;
import processing.data.Sort;

public class StringList
implements Iterable<String> {
    int count;
    String[] data;

    public StringList() {
        this(10);
    }

    public StringList(int length) {
        this.data = new String[length];
    }

    public StringList(String[] list) {
        this.count = list.length;
        this.data = new String[this.count];
        System.arraycopy(list, 0, this.data, 0, this.count);
    }

    public StringList(Iterable<String> iter) {
        this(10);
        for (String s : iter) {
            this.append(s);
        }
    }

    private void crop() {
        if (this.count != this.data.length) {
            this.data = PApplet.subset(this.data, 0, this.count);
        }
    }

    public int size() {
        return this.count;
    }

    public void resize(int length) {
        if (length > this.data.length) {
            String[] temp = new String[length];
            System.arraycopy(this.data, 0, temp, 0, this.count);
            this.data = temp;
        } else if (length > this.count) {
            Arrays.fill(this.data, this.count, length, (Object)0);
        }
        this.count = length;
    }

    public void clear() {
        this.count = 0;
    }

    public String get(int index) {
        return this.data[index];
    }

    public void set(int index, String what) {
        if (index >= this.count) {
            this.data = PApplet.expand(this.data, index + 1);
            for (int i = this.count; i < index; ++i) {
                this.data[i] = null;
            }
            this.count = index + 1;
        }
        this.data[index] = what;
    }

    public String remove(int index) {
        if (index < 0 || index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        String entry = this.data[index];
        for (int i = index; i < this.count - 1; ++i) {
            this.data[i] = this.data[i + 1];
        }
        --this.count;
        return entry;
    }

    public int removeValue(String value) {
        if (value == null) {
            for (int i = 0; i < this.count; ++i) {
                if (this.data[i] != null) continue;
                this.remove(i);
                return i;
            }
        } else {
            int index = this.index(value);
            if (index != -1) {
                this.remove(index);
                return index;
            }
        }
        return -1;
    }

    public int removeValues(String value) {
        int i;
        int ii = 0;
        if (value == null) {
            for (i = 0; i < this.count; ++i) {
                if (this.data[i] == null) continue;
                this.data[ii++] = this.data[i];
            }
        } else {
            for (i = 0; i < this.count; ++i) {
                if (value.equals(this.data[i])) continue;
                this.data[ii++] = this.data[i];
            }
        }
        int removed = this.count - ii;
        this.count = ii;
        return removed;
    }

    public int replaceValue(String value, String newValue) {
        if (value == null) {
            for (int i = 0; i < this.count; ++i) {
                if (this.data[i] != null) continue;
                this.data[i] = newValue;
                return i;
            }
        } else {
            for (int i = 0; i < this.count; ++i) {
                if (!value.equals(this.data[i])) continue;
                this.data[i] = newValue;
                return i;
            }
        }
        return -1;
    }

    public int replaceValues(String value, String newValue) {
        int changed = 0;
        if (value == null) {
            for (int i = 0; i < this.count; ++i) {
                if (this.data[i] != null) continue;
                this.data[i] = newValue;
                ++changed;
            }
        } else {
            for (int i = 0; i < this.count; ++i) {
                if (!value.equals(this.data[i])) continue;
                this.data[i] = newValue;
                ++changed;
            }
        }
        return changed;
    }

    public void append(String value) {
        if (this.count == this.data.length) {
            this.data = PApplet.expand(this.data);
        }
        this.data[this.count++] = value;
    }

    public void append(String[] values) {
        for (String v : values) {
            this.append(v);
        }
    }

    public void append(StringList list) {
        for (String v : list.values()) {
            this.append(v);
        }
    }

    public void insert(int index, String[] values) {
        if (index < 0) {
            throw new IllegalArgumentException("insert() index cannot be negative: it was " + index);
        }
        if (index >= values.length) {
            throw new IllegalArgumentException("insert() index " + index + " is past the end of this list");
        }
        String[] temp = new String[this.count + values.length];
        System.arraycopy(this.data, 0, temp, 0, Math.min(this.count, index));
        System.arraycopy(values, 0, temp, index, values.length);
        System.arraycopy(this.data, index, temp, index + values.length, this.count - index);
        this.count += values.length;
        this.data = temp;
    }

    public void insert(int index, StringList list) {
        this.insert(index, list.values());
    }

    public int index(String what) {
        if (what == null) {
            for (int i = 0; i < this.count; ++i) {
                if (this.data[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.count; ++i) {
                if (!what.equals(this.data[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean hasValue(String value) {
        if (value == null) {
            for (int i = 0; i < this.count; ++i) {
                if (this.data[i] != null) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.count; ++i) {
                if (!value.equals(this.data[i])) continue;
                return true;
            }
        }
        return false;
    }

    public void sort() {
        this.sortImpl(false);
    }

    public void sortReverse() {
        this.sortImpl(true);
    }

    private void sortImpl(final boolean reverse) {
        new Sort(){

            @Override
            public int size() {
                return StringList.this.count;
            }

            @Override
            public float compare(int a, int b) {
                float diff = StringList.this.data[a].compareToIgnoreCase(StringList.this.data[b]);
                return reverse ? -diff : diff;
            }

            @Override
            public void swap(int a, int b) {
                String temp = StringList.this.data[a];
                StringList.this.data[a] = StringList.this.data[b];
                StringList.this.data[b] = temp;
            }
        }.run();
    }

    public void reverse() {
        int ii = this.count - 1;
        for (int i = 0; i < this.count / 2; ++i) {
            String t = this.data[i];
            this.data[i] = this.data[ii];
            this.data[ii] = t;
            --ii;
        }
    }

    public void shuffle() {
        Random r = new Random();
        int num = this.count;
        while (num > 1) {
            int value = r.nextInt(num);
            String temp = this.data[--num];
            this.data[num] = this.data[value];
            this.data[value] = temp;
        }
    }

    public void shuffle(PApplet sketch) {
        int num = this.count;
        while (num > 1) {
            int value = (int)sketch.random(num);
            String temp = this.data[--num];
            this.data[num] = this.data[value];
            this.data[value] = temp;
        }
    }

    public void lower() {
        for (int i = 0; i < this.count; ++i) {
            if (this.data[i] == null) continue;
            this.data[i] = this.data[i].toLowerCase();
        }
    }

    public void upper() {
        for (int i = 0; i < this.count; ++i) {
            if (this.data[i] == null) continue;
            this.data[i] = this.data[i].toUpperCase();
        }
    }

    public StringList copy() {
        StringList outgoing = new StringList(this.data);
        outgoing.count = this.count;
        return outgoing;
    }

    public String[] values() {
        this.crop();
        return this.data;
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            int index = -1;

            @Override
            public void remove() {
                StringList.this.remove(this.index);
            }

            @Override
            public String next() {
                return StringList.this.data[++this.index];
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < StringList.this.count;
            }
        };
    }

    public String[] array() {
        return this.array(null);
    }

    public String[] array(String[] array) {
        if (array == null || array.length != this.count) {
            array = new String[this.count];
        }
        System.arraycopy(this.data, 0, array, 0, this.count);
        return array;
    }

    public StringList getSubset(int start) {
        return this.getSubset(start, this.count - start);
    }

    public StringList getSubset(int start, int num) {
        StringList outgoing = new StringList(num);
        for (int i = 0; i < num; ++i) {
            System.arraycopy(this.data, start, outgoing.data, 0, num);
        }
        return outgoing;
    }

    public String[] getUnique() {
        return this.getTally().keyArray();
    }

    public IntDict getTally() {
        IntDict outgoing = new IntDict();
        for (int i = 0; i < this.count; ++i) {
            outgoing.increment(this.data[i]);
        }
        return outgoing;
    }

    public IntDict getOrder() {
        IntDict outgoing = new IntDict();
        for (int i = 0; i < this.count; ++i) {
            outgoing.set(this.data[i], i);
        }
        return outgoing;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName() + " size=" + this.size() + " [ ");
        for (int i = 0; i < this.size(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(i + ": \"" + this.data[i] + "\"");
        }
        sb.append(" ]");
        return sb.toString();
    }
}

