/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.scene;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import org.taongad.gfx.ManagedPixmap;
import org.taongad.gfx.ManagedTexture;
import org.taongad.scene.Scene;
import org.taongad.scene.StringTheoryScene;
import org.taongad.utils.FastMath;

public class WaveScene
extends StringTheoryScene {
    Pixmap wavePix;
    Texture waveTex;
    BitmapFont scrollerFont;
    Pixmap heart;

    public WaveScene(float startTimeMSec) {
        super(startTimeMSec);
    }

    @Override
    public void load() {
        this.wavePix = new ManagedPixmap(this, 204, 152, Pixmap.Format.RGBA8888);
        this.waveTex = new ManagedTexture((Scene)this, this.wavePix);
        this.heart = new ManagedPixmap(this, Gdx.files.internal("gfx/heart.png"));
        FreeTypeFontGenerator generator = new FreeTypeFontGenerator(Gdx.files.internal("fonts/The 2K12.ttf"));
        this.scrollerFont = generator.generateFont(90);
        generator.dispose();
        this.disposables.add(this.scrollerFont);
    }

    @Override
    protected void draw(float deltaTimeMSec) {
        this.time += deltaTimeMSec;
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.wavePix.setColor(Color.alpha(0.0f));
        this.wavePix.fill();
        this.batch.begin();
        this.drawTestScene();
        this.batch.draw(this.waveTex, 0.0f, 0.0f, 0.0f, 0.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), 1.0f, 1.0f, 0.0f, 0, 0, 204, 152, false, false);
        this.batch.end();
    }

    private void drawTestScene() {
        this.drawCircle(Color.YELLOW);
        this.drawWave(Color.BLUE, 5.0f, 172.5f);
    }

    private void drawCircle(Color waveColor) {
        float baseRadius = 10.0f;
        float ampX = 20.0f;
        float ampY = 20.0f;
        float maxFreq = 10.0f;
        float wave2 = FastMath.sinAbs(4.712389f + this.time * 0.001f);
        float freq = maxFreq * wave2;
        float mod2PIfreq = freq % ((float)Math.PI * 2);
        this.wavePix.setColor(waveColor);
        float i = 0.0f;
        while (i < (float)Math.PI * 2) {
            float freqRest = freq - (float)((int)freq);
            float wave1 = FastMath.sinAbs(i * freq);
            float iPos = i + mod2PIfreq;
            int x = (int)(FastMath.cos(iPos) * (baseRadius + ampX * wave1));
            int y = (int)(FastMath.sin(iPos) * (baseRadius + ampY * wave1));
            this.wavePix.drawPixel(102 + x, 76 - y);
            i += 0.001f;
        }
        this.waveTex.draw(this.wavePix, 0, 0);
    }

    private void drawWave(Color waveColor, float nudgeY, float periodOffs) {
        float wave1 = FastMath.sin(this.time * 0.003f);
        float wave2 = FastMath.sin(this.time * 0.003f);
        float wave5 = FastMath.sin(this.time * 0.0025f);
        float wave6 = FastMath.sin(this.time * 0.0035f);
        float wave7 = FastMath.sin(this.time * 2.5E-4f);
        float wave8 = FastMath.sin(this.time * 3.5E-4f);
        float wave9 = FastMath.sin(this.time * 2.5E-4f);
        float SCREENH_DIV_8 = 9.5f;
        float SCREENH_DIV_2 = 76.0f;
        float amp = SCREENH_DIV_8 + SCREENH_DIV_8 * wave1;
        float offsetY = SCREENH_DIV_2 + SCREENH_DIV_8 * wave2;
        float timeScale = 5.0E-4f;
        float freq = 8.0f;
        float ballStartY = 80.0f;
        float ballAmpY = 40.0f;
        float movementX = 40.0f;
        float tint = 0.5f + wave6 * 0.5f;
        this.scrollerFont.setColor(tint, tint, tint, tint);
        String txt = "String Theory";
        this.scrollerFont.draw(this.batch, "String Theory", 102.0f, 580.0f);
        this.wavePix.setColor(Color.MAGENTA);
        this.wavePix.drawCircle((int)(130.0f + 40.0f * wave7), (int)(80.0f + 40.0f * wave2), 10);
        this.wavePix.drawPixmap(this.heart, (int)(80.0f + 40.0f * wave8), (int)(80.0f + 40.0f * wave5));
        this.wavePix.setColor(Color.WHITE);
        this.wavePix.drawCircle((int)(180.0f + 40.0f * wave9), (int)(80.0f + 40.0f * wave6), 10);
        int x = 0;
        while (x < this.wavePix.getWidth()) {
            float wave3 = FastMath.sin((this.time + (float)(x * 100)) * 0.001f);
            float wave4 = FastMath.sin((this.time + (float)(x * 10)) * 0.001f);
            offsetY = nudgeY + SCREENH_DIV_2 + SCREENH_DIV_8 * wave3;
            amp = SCREENH_DIV_8 + SCREENH_DIV_8 * wave4;
            float waveX = (float)x + periodOffs;
            float timeX = this.time * timeScale;
            float sinY = FastMath.sin((waveX / 204.0f + timeX) * freq * ((float)Math.PI * 2));
            int y = (int)(sinY * amp);
            y = (int)(offsetY - (float)y);
            this.wavePix.setColor(waveColor);
            this.wavePix.drawPixel(x, y);
            this.wavePix.setColor(0.0f, 0.0f, 0.0f, 1.0f);
            this.wavePix.fillCircle((int)(130.0f + 40.0f * wave7), (int)(80.0f + 40.0f * wave2), 9);
            this.wavePix.setColor(0.0f, 0.0f, 0.0f, 1.0f);
            this.wavePix.fillCircle((int)(180.0f + 40.0f * wave9), (int)(80.0f + 40.0f * wave6), 9);
            this.wavePix.setColor(0.0f, 0.0f, 0.0f, 1.0f);
            float colHeight = 152 - y;
            int i = y;
            while (i < 152) {
                this.wavePix.setColor(waveColor.r, waveColor.g, waveColor.b, 1.0f - (float)(i - y) / colHeight * 0.7f);
                this.wavePix.drawPixel(x, i);
                ++i;
            }
            ++x;
        }
        this.waveTex.draw(this.wavePix, 0, 0);
    }
}

