/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.scene;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.taongad.anim.AnimationEvent;
import org.taongad.anim.AnimationSequence;
import org.taongad.anim.drivers.DriverObserver;
import org.taongad.gfx.ManagedPixmap;
import org.taongad.gfx.PixTexSprite;
import org.taongad.scene.StringTheoryScene;
import org.taongad.utils.ColorUtil;
import org.taongad.utils.DriverUtil;
import org.taongad.utils.FastMath;

public class RoboLifeScene
extends StringTheoryScene {
    Pixmap heartPix;
    Color fillColor = new Color(0.0f, 0.2f, 0.0f, 1.0f);
    Random rng = new Random();
    Color lineCol = new Color(0.0f, 0.6f, 0.0f, 1.0f);
    List<GraphData> graphs = new ArrayList<GraphData>();
    PixTexSprite oscGrid;
    BitmapFont scrollerFont;
    Color orgHeartColor = Color.GREEN.cpy();
    Color heartColor = this.orgHeartColor.cpy();
    Color heartColorTarget = Color.PINK.cpy();
    final float maxFadeEdge = 92.0f;
    float fadeEdgeFactor = 1.0f;
    float fadeBGFactor = 0.0f;
    int lastChar = 0;
    Sound beep;
    List<TextBlock> textList = new ArrayList<TextBlock>();
    TextBlock currTxt;
    float drawPosXWave1 = 0.0f;
    float drawPosXWave2 = 0.0f;

    public RoboLifeScene(float startTimeMSec) {
        super(startTimeMSec);
    }

    @Override
    public void load() {
        this.beep = Gdx.audio.newSound(Gdx.files.internal("sfx/BombBeep2.wav"));
        this.disposables.add(this.beep);
        this.anim = new AnimationSequence();
        this.oscGrid = new PixTexSprite(this, Gdx.files.internal("gfx/osc_grid.png"));
        this.oscGrid.getSprite().setOrigin(this.oscGrid.getWidth() / 2, this.oscGrid.getHeight() / 2);
        this.oscGrid.getSprite().setPosition(Gdx.graphics.getWidth() / 2 - this.oscGrid.getWidth() / 2, Gdx.graphics.getHeight() / 2 - this.oscGrid.getHeight() / 2);
        this.graphs.add(new GraphData(0.0f, 76));
        this.graphs.add(new GraphData(1000.0f, 114));
        this.graphs.add(new GraphData(2000.0f, 38));
        this.graphs.add(new GraphData(3000.0f, 95));
        this.graphs.add(new GraphData(4000.0f, 57));
        FreeTypeFontGenerator generator = new FreeTypeFontGenerator(Gdx.files.internal("fonts/Computerfont.ttf"));
        this.scrollerFont = generator.generateFont(80);
        generator.dispose();
        this.disposables.add(this.scrollerFont);
        this.heartPix = new ManagedPixmap(this, 204, 152, Pixmap.Format.RGBA8888);
        this.textList.add(new TextBlock("Whilst humanity explores", "a path to self-destruction..."));
        this.textList.add(new TextBlock("...one thing", "still holds true:"));
        this.textList.add(new TextBlock("No fate,", "but what we make."));
        this.textList.add(new TextBlock("So...", "...fellow sceners..."));
        this.textList.add(new TextBlock("...let us make", "the future brighter."));
        this.setupNextTextBlock(this.textList.remove(0), this.time + 3000.0f);
    }

    private void setupHeart(float startTime) {
        float duration = 4500.0f;
        DriverUtil.setupLerpObserver(this.anim, startTime, startTime + duration, 0.0f, 204.0f, new DriverObserver<Float>(){

            @Override
            public void publishValue(Float value) {
                RoboLifeScene.this.drawPosXWave1 = value.floatValue();
            }
        });
        DriverUtil.setupLerpObserver(this.anim, startTime += 1500.0f, startTime + duration, 0.0f, 204.0f, new DriverObserver<Float>(){

            @Override
            public void publishValue(Float value) {
                RoboLifeScene.this.drawPosXWave2 = value.floatValue();
            }
        });
        DriverUtil.setupLerpObserver(this.anim, startTime += 3500.0f, startTime + 3000.0f, 0.0f, 1.0f, new DriverObserver<Float>(){

            @Override
            public void publishValue(Float value) {
                RoboLifeScene.this.fadeEdgeFactor = 1.0f - value.floatValue();
                RoboLifeScene.this.heartColor = ColorUtil.lerpColors(RoboLifeScene.this.heartColorTarget, RoboLifeScene.this.orgHeartColor, value.floatValue());
            }
        });
    }

    private void setupNextTextBlock(TextBlock txt, float startTime) {
        txt.setTime(startTime);
        this.currTxt = txt;
        DriverUtil.setupLerpObserver(this.anim, new AnimationEvent.OnCompletedListener(){

            @Override
            public void onCompleted(float completedTime) {
                if (RoboLifeScene.this.textList.size() > 0) {
                    RoboLifeScene.this.lastChar = 0;
                    RoboLifeScene.this.setupNextTextBlock(RoboLifeScene.this.textList.remove(0), RoboLifeScene.this.time);
                } else {
                    RoboLifeScene.this.setupHeart(RoboLifeScene.this.time);
                }
            }
        }, startTime, startTime + txt.getRunningTime(), 0.0f, 1.0f, new DriverObserver<Float>(){

            @Override
            public void publishValue(Float value) {
            }
        });
    }

    @Override
    protected void draw(float deltaTimeMSec) {
        this.time += deltaTimeMSec;
        this.log.info("tid: " + this.time);
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.batch.begin();
        this.anim.update(deltaTimeMSec);
        Pixmap bgPix = this.bg.getPixmap();
        bgPix.setColor(this.fillColor);
        bgPix.fill();
        for (GraphData g : this.graphs) {
            g.draw(bgPix, deltaTimeMSec);
        }
        this.drawHeart();
        this.bg.drawPixToTex();
        this.blitAndScaleBG();
        this.oscGrid.getSprite().draw(this.batch, this.fadeEdgeFactor);
        if (this.currTxt != null) {
            this.printText(this.currTxt);
        }
        this.batch.end();
    }

    private void printText(TextBlock txt) {
        if (txt.getTime() < 0.0f) {
            return;
        }
        float charTime = 70.0f;
        float hold = 2500.0f;
        float fade = 500.0f;
        int maxChars = txt.getLine1().length() + txt.getLine2().length();
        int charPos = (int)(txt.getTime() / charTime);
        float fadeStartTime = (float)maxChars * charTime + hold;
        float fadePos = (txt.getTime() < fadeStartTime ? 0.0f : (txt.getTime() < fadeStartTime + fade ? txt.getTime() - fadeStartTime : fade)) / fade;
        this.scrollerFont.setColor(Color.LIGHT_GRAY.r, Color.LIGHT_GRAY.g, Color.LIGHT_GRAY.b, 1.0f - fadePos);
        BitmapFont.TextBounds bounds = this.scrollerFont.getBounds(txt.getLine1());
        float xOffsTxt = Gdx.graphics.getWidth() / 2;
        float yOffsTxt = (float)(Gdx.graphics.getHeight() / 2) + bounds.height * 1.5f;
        charPos = charPos > maxChars ? maxChars : charPos;
        int n = charPos = charPos < 0 ? 0 : charPos;
        if (charPos > this.lastChar) {
            this.beep.play();
            this.lastChar = charPos;
        }
        float cursorTime = 130.0f;
        this.scrollerFont.draw(this.batch, String.valueOf(txt.getLine1().substring(0, charPos > txt.getLine1().length() ? txt.getLine1().length() : charPos)) + (this.time % (cursorTime * 2.0f) > cursorTime && charPos < txt.getLine1().length() ? "_" : ""), xOffsTxt - bounds.width / 2.0f, yOffsTxt);
        bounds = this.scrollerFont.getBounds(txt.getLine2());
        this.scrollerFont.draw(this.batch, String.valueOf(txt.getLine2().substring(0, charPos > txt.getLine1().length() ? charPos - txt.getLine1().length() : 0)) + (this.time % (cursorTime * 2.0f) > cursorTime && charPos > txt.getLine1().length() ? "_" : ""), xOffsTxt - bounds.width / 2.0f, yOffsTxt - 80.0f);
    }

    private void drawHeart() {
        float y;
        Pixmap bgPix = this.heartPix;
        bgPix.setColor(0.0f, 0.0f, 0.0f, 1.0f - this.fadeEdgeFactor);
        bgPix.fill();
        float baseOffsY = 0.0f;
        float amp = 12.0f;
        float freq = 8.0f;
        float offsY = baseOffsY + 1.0f;
        float x = 0.0f;
        while (x < this.drawPosXWave1) {
            bgPix.setColor(this.heartColor.r, this.heartColor.g, this.heartColor.b, this.calcAlphaForHeartCol(x));
            y = 76.0f - offsY - Math.abs(FastMath.sin(x / 204.0f * ((float)Math.PI * 2) * freq)) * amp;
            bgPix.drawPixel((int)x, (int)y);
            x += 0.01f;
        }
        amp = 60.0f;
        freq = 1.0f;
        offsY = baseOffsY - 22.0f;
        x = 0.0f;
        while (x < this.drawPosXWave2) {
            bgPix.setColor(this.heartColor.r, this.heartColor.g, this.heartColor.b, this.calcAlphaForHeartCol(x));
            y = 76.0f - offsY - Math.abs(FastMath.sin(x / 204.0f * ((float)Math.PI * 2) * freq)) * amp;
            bgPix.drawPixel((int)x, (int)y);
            x += 0.01f;
        }
        this.bg.getPixmap().drawPixmap(bgPix, 0, 0);
    }

    private float calcAlphaForHeartCol(float x) {
        float halfHeartW = 13.0f;
        float leftSideHeart = 102.0f - halfHeartW;
        float leftLeftSideHeart = 102.0f - halfHeartW - 92.0f * this.fadeEdgeFactor;
        float rightSideHeart = 102.0f + halfHeartW;
        float rightRightSideHeart = 102.0f + halfHeartW + 92.0f * this.fadeEdgeFactor;
        float a = 0.0f;
        float maxA = 0.1f;
        a = x < leftLeftSideHeart || x > rightRightSideHeart ? 0.0f : (x > leftLeftSideHeart && x < leftSideHeart ? maxA * (x - leftLeftSideHeart) / (leftSideHeart - leftLeftSideHeart) : (x > rightSideHeart && x < rightRightSideHeart ? maxA * (1.0f - (x - rightSideHeart) / (rightRightSideHeart - rightSideHeart)) : 1.0f));
        return a;
    }

    private void drawLineTest(Pixmap bgPix) {
        int xLen = 140;
        int y = 50;
        Color pixelCol = this.lineCol.cpy();
        int x = 30;
        int travelLen = xLen - x;
        int currTravelPos = 0;
        while (x < xLen) {
            pixelCol.set(this.lineCol.r, this.lineCol.g, this.lineCol.b, (float)currTravelPos / (float)travelLen);
            bgPix.setColor(pixelCol);
            bgPix.drawPixel(x, y);
            ++x;
            ++currTravelPos;
        }
        bgPix.setColor(Color.GREEN);
        bgPix.drawPixel(xLen, y);
    }

    class GraphData {
        float startTime;
        GraphLine instance;
        int yPos;

        public GraphData(float startTime, int yPos) {
            this.startTime = startTime;
            this.yPos = yPos;
        }

        public void draw(Pixmap drawTarget, float deltaTimeMSec) {
            if (this.instance == null && RoboLifeScene.this.time > this.startTime) {
                this.instance = new GraphLine(this.yPos);
            }
            if (this.instance != null) {
                if (this.instance.isDone()) {
                    this.instance = new GraphLine(this.yPos);
                }
                this.instance.move(deltaTimeMSec);
                this.instance.draw(drawTarget);
            }
        }
    }

    class GraphLine {
        int baseY;
        final float SPEED_PER_FRAME = 4.0f;
        static final float FRAME_TIME = 16.666666f;
        final int minSegments = 5;
        final int maxSegments = 10;
        int totalLineSegDistance;
        int[] lineSegments;
        int[] verticalLineSegments;
        int[] segmentCutPoints;
        float pos;
        int len = 60;
        Line[] lines;

        public GraphLine(int y) {
            this.baseY = y;
            this.lineSegments = new int[(int)(5.0f + RoboLifeScene.this.rng.nextFloat() * 5.0f)];
            this.segmentCutPoints = new int[this.lineSegments.length - 1];
            this.verticalLineSegments = new int[this.lineSegments.length - 1];
            this.lines = new Line[this.lineSegments.length + this.segmentCutPoints.length];
            this.generateCutPoints();
        }

        private void generateCutPoints() {
            int avgCutDist = 204 / this.lineSegments.length;
            int amp = 5;
            int deviation = 10;
            int xDistUsed = 0;
            int i = 0;
            while (i < this.segmentCutPoints.length) {
                int segmentLen = avgCutDist + (int)((RoboLifeScene.this.rng.nextFloat() - 0.5f) * 2.0f * (float)deviation);
                this.lineSegments[i] = xDistUsed + segmentLen;
                this.segmentCutPoints[i] = xDistUsed += segmentLen;
                this.verticalLineSegments[i] = amp + (int)((RoboLifeScene.this.rng.nextFloat() - 0.5f) * 2.0f * (float)deviation);
                ++i;
            }
            this.lineSegments[this.segmentCutPoints.length] = 204 - xDistUsed;
            int prevX = 0;
            int yPos = this.baseY;
            int currLine = 0;
            int i2 = 0;
            while (i2 < this.segmentCutPoints.length) {
                int yDist = yPos == this.baseY ? this.baseY + this.verticalLineSegments[i2] : (yPos > this.baseY ? this.baseY - this.verticalLineSegments[i2] : this.baseY + this.verticalLineSegments[i2]);
                this.lines[currLine++] = new HLine(prevX, yPos, this.lineSegments[i2] - prevX);
                this.lines[currLine++] = new VLine(this.lineSegments[i2], yPos, yDist - yPos, yDist - yPos >= 0);
                yPos = yDist;
                prevX = this.lineSegments[i2];
                ++i2;
            }
            this.lines[currLine++] = new HLine(prevX, yPos, 204 - prevX);
            this.totalLineSegDistance = 0;
            Line[] lineArray = this.lines;
            int n = this.lines.length;
            int n2 = 0;
            while (n2 < n) {
                Line line = lineArray[n2];
                this.totalLineSegDistance += line.getLen();
                ++n2;
            }
        }

        public boolean isDone() {
            return this.pos - (float)this.len > (float)this.totalLineSegDistance;
        }

        public void move(float deltaTimeMSec) {
            this.pos += deltaTimeMSec / 16.666666f * 4.0f;
        }

        public void draw(Pixmap drawTarget) {
            int start = (int)(this.pos - (float)this.len < 0.0f ? 0.0f : this.pos - (float)this.len);
            int stop = (int)this.pos;
            int dist = 0;
            int startSeg = 0;
            int stopSeg = 0;
            int startDist = 0;
            int i = 0;
            while (i < this.lines.length) {
                if (start >= dist && start <= dist + this.lines[i].getLen()) {
                    startSeg = i;
                    startDist = dist;
                }
                if (stop >= dist && stop <= dist + this.lines[i].getLen()) {
                    stopSeg = i;
                    break;
                }
                dist += this.lines[i].getLen();
                ++i;
            }
            int currPos = 0;
            int i2 = startSeg;
            while (i2 <= stopSeg) {
                currPos = this.lines[i2].drawSegment(drawTarget, start - startDist < 0 ? 0 : start - startDist, currPos, stop - start);
                startDist += this.lines[i2].getLen();
                ++i2;
            }
        }

        class HLine
        extends Line {
            public HLine(int xPos, int yPos, int len) {
                super(xPos, yPos, len);
            }

            @Override
            int drawSegment(Pixmap drawTarget, int startPos, int currTravelPos, int totalTravelLen) {
                Color pixelCol = ((GraphLine)GraphLine.this).RoboLifeScene.this.lineCol.cpy();
                int linePos = startPos;
                int x = this.xPos + startPos;
                while (linePos < this.len && currTravelPos < totalTravelLen) {
                    pixelCol.set(((GraphLine)GraphLine.this).RoboLifeScene.this.lineCol.r, ((GraphLine)GraphLine.this).RoboLifeScene.this.lineCol.g, ((GraphLine)GraphLine.this).RoboLifeScene.this.lineCol.b, (float)currTravelPos / (float)totalTravelLen);
                    drawTarget.setColor(pixelCol);
                    drawTarget.drawPixel(x, this.yPos);
                    ++linePos;
                    ++x;
                    ++currTravelPos;
                }
                return currTravelPos;
            }
        }

        abstract class Line {
            int xPos;
            int yPos;
            int len;

            public Line(int xPos, int yPos, int len) {
                this.xPos = xPos;
                this.yPos = yPos;
                this.len = Math.abs(len);
            }

            public int getLen() {
                return this.len;
            }

            abstract int drawSegment(Pixmap var1, int var2, int var3, int var4);

            public String toString() {
                return "x: " + this.xPos + ", y: " + this.yPos + ", len: " + this.len;
            }
        }

        class VLine
        extends Line {
            boolean goingUp;

            public VLine(int xPos, int yPos, int len, boolean goingUp) {
                super(xPos, yPos, len);
                this.goingUp = goingUp;
            }

            @Override
            int drawSegment(Pixmap drawTarget, int startPos, int currTravelPos, int totalTravelLen) {
                Color pixelCol = ((GraphLine)GraphLine.this).RoboLifeScene.this.lineCol.cpy();
                int linePos = startPos;
                int y = this.yPos + (this.goingUp ? startPos : -startPos);
                while (linePos < this.len && currTravelPos < totalTravelLen) {
                    pixelCol.set(((GraphLine)GraphLine.this).RoboLifeScene.this.lineCol.r, ((GraphLine)GraphLine.this).RoboLifeScene.this.lineCol.g, ((GraphLine)GraphLine.this).RoboLifeScene.this.lineCol.b, (float)currTravelPos / (float)totalTravelLen);
                    drawTarget.setColor(pixelCol);
                    drawTarget.drawPixel(this.xPos, y);
                    y = this.goingUp ? ++y : --y;
                    ++linePos;
                    ++currTravelPos;
                }
                return currTravelPos;
            }

            @Override
            public String toString() {
                return String.valueOf(super.toString()) + ", up: " + this.goingUp;
            }
        }
    }

    class TextBlock {
        String txt1;
        String txt2;
        float creationTime;

        public TextBlock(String txt1, String txt2) {
            this.txt1 = txt1;
            this.txt2 = txt2;
        }

        public void setTime(float time) {
            this.creationTime = time;
        }

        public float getTime() {
            return RoboLifeScene.this.time - this.creationTime;
        }

        public String getLine1() {
            return this.txt1;
        }

        public String getLine2() {
            return this.txt2;
        }

        public float getRunningTime() {
            return 70 * (this.txt1.length() + this.txt2.length()) + 2500 + 1500;
        }
    }
}

