/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.scene;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import org.taongad.anim.AnimationEvent;
import org.taongad.anim.AnimationSequence;
import org.taongad.anim.drivers.DriverObserver;
import org.taongad.scene.StringTheoryScene;
import org.taongad.utils.DriverUtil;
import org.taongad.utils.FastMath;

public class CreditsScene
extends StringTheoryScene {
    final float waveTimeScale_1 = 0.005f;
    final float orgTimeScale1 = 0.001f;
    float timeScale1 = 0.001f;
    float animTime;
    BitmapFont fontHeader;
    BitmapFont fontCredit;
    BitmapFont fontLogo;
    BitmapFont fontThanks;
    Color darkGray = new Color(0.2f, 0.2f, 0.2f, 1.0f);
    float logoBaseY = 570.0f;
    float logoBaseX = 70.0f;
    float lineHeight = 80.0f;

    public CreditsScene(float startTimeMSec) {
        super(startTimeMSec);
    }

    @Override
    public void load() {
        this.anim = new AnimationSequence();
        FreeTypeFontGenerator generator = new FreeTypeFontGenerator(Gdx.files.internal("fonts/Computerfont.ttf"));
        this.fontHeader = generator.generateFont(40);
        this.fontCredit = generator.generateFont(70);
        generator.dispose();
        generator = new FreeTypeFontGenerator(Gdx.files.internal("fonts/Computerfont.ttf"));
        this.fontLogo = generator.generateFont(90);
        generator.dispose();
        this.setupEffectCycle();
    }

    private void setupEffectCycle() {
        float cycleTime = 10000.0f;
        DriverUtil.setupLerpObserver(this.anim, this.time, this.time + cycleTime, 0.0f, cycleTime, new DriverObserver<Float>(){

            @Override
            public void publishValue(Float value) {
                CreditsScene.this.animTime = value.floatValue();
            }
        });
        DriverUtil.setupLerpObserver(this.anim, new AnimationEvent.OnCompletedListener(){

            @Override
            public void onCompleted(float completedTime) {
                CreditsScene.this.timeScale1 = 0.001f;
                CreditsScene.this.animTime = 0.0f;
                CreditsScene.this.setupEffectCycle();
            }
        }, this.time + cycleTime, this.time + cycleTime * 2.0f, cycleTime, 0.0f, new DriverObserver<Float>(){

            @Override
            public void publishValue(Float value) {
                CreditsScene.this.animTime = value.floatValue();
            }
        });
    }

    @Override
    protected void draw(float deltaTimeMSec) {
        this.time += deltaTimeMSec;
        this.anim.update(deltaTimeMSec);
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.batch.begin();
        this.drawExplodingCircle1(Color.YELLOW, this.animTime, 147, 116, 30.0f);
        this.bg.drawPixToTex();
        this.blitAndScaleBG();
        float baseY = 520.0f;
        float baseX = 750.0f;
        this.fontHeader.setColor(this.darkGray);
        this.fontCredit.setColor(this.darkGray);
        String title1 = "CODE/MUSIC";
        BitmapFont.TextBounds bounds = this.fontHeader.getBounds(title1);
        this.fontHeader.draw(this.batch, title1, baseX - bounds.width / 2.0f, baseY);
        String name1 = "Burre/TAONGAD";
        bounds = this.fontHeader.getBounds(name1);
        this.fontHeader.setColor(Color.WHITE);
        this.fontHeader.draw(this.batch, name1, baseX - bounds.width / 2.0f, baseY - 40.0f);
        String title2 = "GFX";
        this.fontHeader.setColor(this.darkGray);
        bounds = this.fontHeader.getBounds(title2);
        this.fontHeader.draw(this.batch, title2, baseX - bounds.width / 2.0f, baseY -= 90.0f);
        String name2 = "Alex/TAONGAD";
        this.fontHeader.setColor(Color.WHITE);
        bounds = this.fontHeader.getBounds(name2);
        this.fontHeader.draw(this.batch, name2, baseX - bounds.width / 2.0f, baseY - 40.0f);
        this.fontHeader.setColor(Color.WHITE.cpy());
        this.fontCredit.setColor(Color.WHITE.cpy());
        String demoName = "tao003 - The java.lang.String Theory";
        bounds = this.fontHeader.getBounds(demoName);
        this.fontHeader.setColor(this.darkGray);
        this.fontHeader.draw(this.batch, demoName, (float)(Gdx.graphics.getWidth() / 2) - bounds.width / 2.0f, Gdx.graphics.getHeight() - 90);
        String releasedAt = "- Released at Edison 2013 -";
        bounds = this.fontHeader.getBounds(releasedAt);
        this.fontHeader.setColor(Color.WHITE);
        this.fontHeader.draw(this.batch, releasedAt, (float)(Gdx.graphics.getWidth() / 2) - bounds.width / 2.0f, (float)(Gdx.graphics.getHeight() - 90) - bounds.height * 1.5f);
        String thanks = "Thanks for watching!";
        bounds = this.fontLogo.getBounds(thanks);
        this.fontLogo.setColor(Color.WHITE);
        this.fontLogo.draw(this.batch, thanks, (float)(Gdx.graphics.getWidth() / 2) - bounds.width / 2.0f, Gdx.graphics.getHeight() - 20);
        int i = 0;
        i = this.drawLogoRow("The", i);
        i = this.drawLogoRow("Art", i);
        i = this.drawLogoRow("Of", i);
        i = this.drawLogoRow("Never", i);
        i = this.drawLogoRow("Getting", i);
        i = this.drawLogoRow("Anything", i);
        i = this.drawLogoRow("Done", i);
        this.batch.end();
    }

    private int drawLogoRow(String text, int i) {
        String firstChar = text.substring(0, 1);
        BitmapFont.TextBounds bounds = this.fontLogo.getBounds(firstChar);
        this.fontLogo.setColor(Color.WHITE);
        this.fontLogo.draw(this.batch, firstChar, this.logoBaseX, this.logoBaseY - this.lineHeight * (float)i);
        this.fontLogo.setColor(this.darkGray);
        this.fontLogo.draw(this.batch, text.substring(1, text.length()), this.logoBaseX + bounds.width, this.logoBaseY - this.lineHeight * (float)i++);
        return i;
    }

    private void drawExplodingCircle1(Color waveColor, float currTime, int posX, int posY, float size) {
        float ampX = size;
        float ampY = size;
        float maxFreq = 1.0f;
        float timeAccel = 1.0E-7f;
        this.timeScale1 += timeAccel;
        float scaledTime = currTime * this.timeScale1;
        float wave2 = 0.5f + FastMath.sinAbs(4.712389f + currTime * 0.005f);
        float freq = maxFreq * (scaledTime * 0.1f);
        float mod2PIfreq = freq % ((float)Math.PI * 2);
        ampX *= 1.0f;
        ampY *= 1.0f;
        this.bg.clearPix();
        this.bg.getPixmap().setColor(waveColor);
        float i = 0.0f;
        while (i < (float)Math.PI * 2) {
            float wave1 = FastMath.sin(i * freq * 2.0f);
            float wave3 = FastMath.sin(i * freq * 3.0f);
            float iPos = i + mod2PIfreq;
            int x = (int)(FastMath.cos(iPos * wave1) * (0.0f + ampX));
            int y = (int)(FastMath.sin(iPos * wave3) * (0.0f + ampY));
            this.bg.getPixmap().drawPixel(posX + x, posY - y);
            i += 0.001f;
        }
        this.bg.drawPixToTex();
    }
}

