/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.effects;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.Disposable;
import com.bitfire.postprocessing.PostProcessor;
import com.bitfire.postprocessing.PostProcessorListener;
import com.bitfire.postprocessing.effects.Bloom;
import com.bitfire.postprocessing.effects.CrtMonitor;
import com.bitfire.postprocessing.effects.Curvature;
import com.bitfire.postprocessing.effects.Vignette;
import com.bitfire.postprocessing.effects.Zoomer;
import com.bitfire.postprocessing.filters.RadialBlur;

public final class PostProcessing
implements Disposable,
PostProcessorListener {
    public PostProcessor postProcessor;
    public Bloom bloom;
    public Curvature curvature;
    public Zoomer zoomer;
    public CrtMonitor crt;
    public Vignette vignette;
    public boolean blending;
    public boolean zoomRadialBlur;
    public float zoomAmount;
    public float zoomFactor;

    public PostProcessing() {
        boolean isDesktop = Gdx.app.getType() == Application.ApplicationType.Desktop;
        int vpW = Gdx.graphics.getWidth();
        int vpH = Gdx.graphics.getHeight();
        this.blending = false;
        this.postProcessor = new PostProcessor(false, false, isDesktop);
        this.postProcessor.setListener(this);
        PostProcessor.EnableQueryStates = false;
        this.bloom = new Bloom((int)((float)Gdx.graphics.getWidth() * 0.25f), (int)((float)Gdx.graphics.getHeight() * 0.25f));
        this.curvature = new Curvature();
        this.zoomer = new Zoomer(vpW, vpH, isDesktop ? RadialBlur.Quality.VeryHigh : RadialBlur.Quality.Low);
        this.crt = new CrtMonitor(vpW, vpH, false, false);
        this.vignette = new Vignette(vpW, vpH, false);
        this.postProcessor.addEffect(this.curvature);
        this.postProcessor.addEffect(this.zoomer);
        this.postProcessor.addEffect(this.vignette);
        this.postProcessor.addEffect(this.crt);
        this.postProcessor.addEffect(this.bloom);
        this.initializeEffects();
    }

    private void initializeEffects() {
        this.zoomer.setBlurStrength(-0.1f);
        this.zoomer.setOrigin(Gdx.graphics.getWidth() / 2, Gdx.graphics.getHeight() / 2);
        this.curvature.setZoom(0.73f);
        this.curvature.setDistortion(1.2f);
        this.crt.setColorOffset(0.0f);
        this.crt.setDistortion(1.1f);
        this.vignette.setIntensity(2.0f);
        this.bloom.setBaseIntesity(1.0f);
        this.bloom.setThreshold(0.01f);
        this.bloom.setBlurAmount(1.2f);
        this.bloom.setBaseSaturation(1.5f);
        this.bloom.setBloomIntesity(1.8f);
        this.crt.setEnabled(true);
        this.vignette.setEnabled(true);
        this.curvature.setEnabled(true);
        this.zoomer.setEnabled(false);
        this.bloom.setEnabled(true);
    }

    @Override
    public void dispose() {
        this.postProcessor.dispose();
    }

    public boolean begin() {
        return this.postProcessor.capture();
    }

    public void end() {
        this.postProcessor.render();
    }

    public void rebind() {
        this.postProcessor.rebind();
    }

    public boolean isEnabled() {
        return this.postProcessor.isEnabled();
    }

    public boolean isReady() {
        return this.postProcessor.isReady();
    }

    public void setEnabled(boolean enabled) {
        this.postProcessor.setEnabled(enabled);
    }

    public void update(float elapsedSecs) {
        float smoothing = 1.5f;
        this.zoomFactor = PostProcessing.lerp(this.zoomFactor * smoothing, this.zoomAmount / smoothing, 0.1f) * 0.5f;
        this.zoomer.setZoom(1.0f + 4.0f * this.zoomFactor);
        if (this.zoomRadialBlur) {
            this.zoomer.setBlurStrength(-0.1f * this.zoomFactor);
        }
        this.crt.setTime(elapsedSecs);
    }

    @Override
    public void beforeRenderToScreen() {
        if (this.blending) {
            Gdx.gl20.glEnable(3042);
            Gdx.gl20.glBlendFunc(768, 770);
        }
    }

    private static float lerp(float prev, float curr, float alpha) {
        return prev + alpha * (curr - prev);
    }
}

