/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.anim;

import java.util.ArrayList;
import java.util.List;

public abstract class AnimationEvent {
    protected final float startTime;
    protected final float endTime;
    protected final float runningTime;
    private List<OnCompletedListener> onCompletedListeners;
    private List<OnStartedListener> onStartedListeners;

    public AnimationEvent(float startTime, float endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.runningTime = endTime - startTime;
        this.onCompletedListeners = new ArrayList<OnCompletedListener>();
        this.onStartedListeners = new ArrayList<OnStartedListener>();
    }

    public abstract void update(float var1);

    public boolean isStarting(float totalRunningTime) {
        return totalRunningTime >= this.startTime;
    }

    public boolean isDone(float totalRunningTime) {
        boolean isDone;
        boolean bl = isDone = totalRunningTime >= this.endTime;
        if (isDone) {
            for (OnCompletedListener listener : this.onCompletedListeners) {
                listener.onCompleted(totalRunningTime);
            }
        }
        return isDone;
    }

    public void registerOnStartedListener(OnStartedListener onStartedListener) {
        if (!this.onStartedListeners.contains(onStartedListener)) {
            this.onStartedListeners.add(onStartedListener);
        }
    }

    public void registerOnCompletedListener(OnCompletedListener onCompletedListener) {
        if (!this.onCompletedListeners.contains(onCompletedListener)) {
            this.onCompletedListeners.add(onCompletedListener);
        }
    }

    public void dispose() {
        this.onStartedListeners.clear();
        this.onCompletedListeners.clear();
    }

    public static interface OnCompletedListener {
        public void onCompleted(float var1);
    }

    public static interface OnStartedListener {
        public void onStarted();
    }
}

