/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.model.keyframe;

import com.badlogic.gdx.graphics.g3d.materials.Material;
import com.badlogic.gdx.graphics.g3d.model.AnimatedModel;
import com.badlogic.gdx.graphics.g3d.model.Model;
import com.badlogic.gdx.graphics.g3d.model.SubMesh;
import com.badlogic.gdx.graphics.g3d.model.keyframe.Keyframe;
import com.badlogic.gdx.graphics.g3d.model.keyframe.KeyframedAnimation;
import com.badlogic.gdx.graphics.g3d.model.keyframe.KeyframedSubMesh;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.collision.BoundingBox;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class KeyframedModel
implements AnimatedModel,
Disposable {
    public final KeyframedSubMesh[] subMeshes;
    protected final KeyframedAnimation[] animations;
    private static final BoundingBox tmpBox = new BoundingBox();

    public KeyframedModel(KeyframedSubMesh[] subMeshes) {
        this.subMeshes = subMeshes;
        Array<KeyframedAnimation> meshAnims = subMeshes[0].animations.values().toArray();
        this.animations = new KeyframedAnimation[meshAnims.size];
        for (int i = 0; i < this.animations.length; ++i) {
            this.animations[i] = meshAnims.get(i);
        }
        this.checkValidity();
    }

    private void checkValidity() {
        int i;
        for (i = 0; i < this.subMeshes.length; ++i) {
            if (this.subMeshes[i].animations.size == this.animations.length) continue;
            throw new GdxRuntimeException("number of animations in subMesh[0] is not the same in subMesh[" + i + "]. All sub-meshes must have the same animations and number of frames");
        }
        for (i = 0; i < this.animations.length; ++i) {
            KeyframedAnimation anim = this.animations[i];
            for (int j = 0; j < this.subMeshes.length; ++j) {
                KeyframedAnimation otherAnim = this.subMeshes[j].animations.get(anim.name);
                if (otherAnim == null) {
                    throw new GdxRuntimeException("animation '" + anim.name + "' missing in subMesh[" + j + "]");
                }
                if (otherAnim.frameDuration != anim.frameDuration) {
                    throw new GdxRuntimeException("animation '" + anim.name + "' in subMesh[" + j + "] has different frame duration than the same animation in subMesh[0]");
                }
                if (otherAnim.keyframes.length == anim.keyframes.length) continue;
                throw new GdxRuntimeException("animation '" + anim.name + "' in subMesh[" + j + "] has different number of keyframes than the same animation in subMesh[0]");
            }
        }
    }

    @Override
    public void render() {
        int len = this.subMeshes.length;
        for (int i = 0; i < len; ++i) {
            KeyframedSubMesh subMesh = this.subMeshes[i];
            if (i == 0 || !this.subMeshes[i - 1].material.equals(subMesh.material)) {
                subMesh.material.bind();
            }
            subMesh.mesh.render(subMesh.primitiveType);
        }
    }

    @Override
    public void render(ShaderProgram program) {
        int len = this.subMeshes.length;
        for (int i = 0; i < len; ++i) {
            KeyframedSubMesh subMesh = this.subMeshes[i];
            if (i == 0 || !this.subMeshes[i - 1].material.equals(subMesh.material)) {
                subMesh.material.bind(program);
            }
            subMesh.mesh.render(program, subMesh.primitiveType);
        }
    }

    @Override
    public void setMaterials(Material ... materials) {
        if (materials.length != this.subMeshes.length) {
            throw new UnsupportedOperationException("number of materials must equal number of sub-meshes");
        }
        for (Material this.subMeshes[i].material : materials) {
        }
    }

    @Override
    public void setMaterial(Material material) {
        int len = this.subMeshes.length;
        for (int i = 0; i < len; ++i) {
            this.subMeshes[i].material = material;
        }
    }

    @Override
    public KeyframedSubMesh getSubMesh(String name) {
        int len = this.subMeshes.length;
        for (int i = 0; i < len; ++i) {
            if (!this.subMeshes[i].name.equals(name)) continue;
            return this.subMeshes[i];
        }
        return null;
    }

    @Override
    public SubMesh[] getSubMeshes() {
        return this.subMeshes;
    }

    @Override
    public void setAnimation(String animation, float time, boolean loop) {
        int len = this.subMeshes.length;
        for (int i = 0; i < len; ++i) {
            KeyframedSubMesh subMesh = this.subMeshes[i];
            KeyframedAnimation anim = subMesh.animations.get(animation);
            if (anim == null) {
                throw new IllegalArgumentException("No animation with name '" + animation + "' in submesh #" + i);
            }
            if (time < 0.0f || time > anim.totalDuration) {
                throw new IllegalArgumentException("time must be 0 <= time <= animation duration");
            }
            int startIndex = (int)Math.floor(time / anim.frameDuration);
            Keyframe startFrame = anim.keyframes[startIndex];
            Keyframe endFrame = anim.keyframes[anim.keyframes.length - 1 == startIndex ? (loop ? 0 : startIndex) : startIndex + 1];
            int numComponents = subMesh.animatedComponents;
            float[] src = startFrame.vertices;
            int srcLen = numComponents * subMesh.mesh.getNumVertices();
            float[] dst = subMesh.blendedVertices;
            int dstInc = subMesh.mesh.getVertexSize() / 4 - numComponents;
            if (startFrame == endFrame) {
                int srcIdx = 0;
                int dstIdx = 0;
                while (srcIdx < srcLen) {
                    for (int j = 0; j < numComponents; ++j) {
                        dst[dstIdx++] = src[srcIdx++];
                    }
                    dstIdx += dstInc;
                }
            } else {
                float[] src2 = endFrame.vertices;
                float alpha = (time - (float)startIndex * anim.frameDuration) / anim.frameDuration;
                int srcIdx = 0;
                int dstIdx = 0;
                while (srcIdx < srcLen) {
                    for (int j = 0; j < numComponents; ++j) {
                        float valSrc = src[srcIdx];
                        float valSrc2 = src2[srcIdx++];
                        dst[dstIdx++] = valSrc + (valSrc2 - valSrc) * alpha;
                    }
                    dstIdx += dstInc;
                }
            }
            subMesh.mesh.setVertices(dst);
        }
    }

    @Override
    public KeyframedAnimation getAnimation(String name) {
        return this.subMeshes[0].animations.get(name);
    }

    public KeyframedAnimation[] getAnimations() {
        return this.animations;
    }

    @Override
    public Model getSubModel(String ... subMeshNames) {
        return null;
    }

    @Override
    public void getBoundingBox(BoundingBox bbox) {
        bbox.inf();
        for (int i = 0; i < this.subMeshes.length; ++i) {
            this.subMeshes[i].mesh.calculateBoundingBox(tmpBox);
            bbox.ext(tmpBox);
        }
    }

    @Override
    public void dispose() {
        for (int i = 0; i < this.subMeshes.length; ++i) {
            this.subMeshes[i].mesh.dispose();
        }
    }
}

