/** Set up audio control */
var audio = document.createElement( 'audio' );
audio.src = 'survive.ogg';
audio.style.opacity = 0;
audio.controls = true;
document.body.appendChild( audio );

function startDemo(SCROLLER_REZ) {

/** Hide audio controls after some time */
var timeoutID;
document.addEventListener( 'mousemove', function (event) {
	audio.style.opacity = 0.5;
	if (timeoutID !== undefined) { clearTimeout(timeoutID); }
	timeoutID = setTimeout(function () { audio.style.opacity = 0; }, 1000);
});

/** Set up audio analyser */
window.AudioContext = window.AudioContext || window.webkitAudioContext;
var source, context = new AudioContext();
var analyser = context.createAnalyser();
try {
	source = context.createMediaElementSource(audio);
	source.connect(analyser);
	analyser.connect(context.destination);
} catch(e) { alert('Web Audio API is not supported in this browser'); }

/** Start the magic */
var angle = 0;
var gl = GL.create();

var shader = new GL.Shader('\
	void main() {\
		gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;\
	}\
', '\
	uniform float intensityB;\
	uniform float intensityG;\
	uniform sampler2D texture;\
	void main() {\
		gl_FragColor = vec4(0.0, intensityG, intensityB, 1.0);\
	}\
');

gl.onupdate = function(seconds) {
	angle += 45 * seconds;
};

var cubes = [];
var cube = GL.Mesh.cube();
var plane = GL.Mesh.plane();

var vertexShader = '\
    varying vec2 coord;\
    void main() {\
      coord = gl_Vertex.xy * 0.5 + 0.5;\
      gl_Position = vec4(gl_Vertex.xyz, 1.0);\
    }\
  ';

/** Start scroller */
var ig = document.createElement('canvas');
var c2d = ig.getContext('2d');
c2d.canvas.width = c2d.canvas.height = SCROLLER_REZ;
c2d.font = SCROLLER_REZ/25+"px 'Press Start 2P'";
c2d.fillStyle = "rgb(255, 255, 255)";
var gradient = c2d.createLinearGradient(0, 0, 150, 250);
gradient.addColorStop(0, "rgb(255, 0, 0)");
gradient.addColorStop(1, "rgb(255, 255, 0)");
c2d.fillStyle = gradient;
var textCanvas = c2d.canvas;
var textMesh = GL.Mesh.plane({ coords: true });

var textShader = new GL.Shader('\
	  varying vec2 coord;\
	  void main() {\
	    coord = gl_TexCoord.xy;\
	    gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;\
	  }\
	', '\
	  uniform sampler2D texture;\
	  varying vec2 coord;\
	  void main() {\
	    gl_FragColor = texture2D(texture, coord);\
	  }\
	');
var textString = "hello DEMODAYS world. caesar cum spectavit \
portum plenum esse, luxta navigavit ////   \
music:   Germany Germany - Survive (Bear Mountain remix) \
                                                 \
    vera fides rara est           _5315M      @DEMODAYS2013";

var p1 = 0,
    p2 = 0,
    p3 = 0,
    p4 = 0,
    t1, t2, t3, t4,
    aSin = [], 
    ti = 15,
    cd = c2d.createImageData(SCROLLER_REZ, SCROLLER_REZ),
    rad,
    i, j, x,
    idx,
    as = 1, fd = 0.4, as1 = 4.4, fd1 = 2.2, ps = -4.4, ps2 = 3.3;

as=4.423780153738335;fd=7.27389178937301;as1=18.67820523912087;fd2=35.00911520095542;ps=7.58058276027441;ps2=15.367055116221309;

function rand(va) {
  return Math.random(va);
}

gl.start = function() {
/*	for(var i=0; i<analyser.frequencyBinCount; i++){
		var cu = GL.Mesh.cube();
		cubes.push( cu );
	}*/
	
  var i = 512;
  while (i--) {
    rad = (i * 0.703125) * 0.0174532;
    aSin[i] = Math.sin(rad) * 1024;
  }
}

/* Glitch me beautiful */
var photo = new Image(), photodata = null, photocanvas, photoctx;
photo.src = "4344811982_b31e7c0cfa_o.jpg";
photo.addEventListener( 'load', function() {
	photocanvas = document.createElement('canvas');
	photoctx = photocanvas.getContext('2d');
	photoctx.drawImage(photo, 0, 0);
	//photodata = c2d.getImageData( 0, 0, SCROLLER_REZ, SCROLLER_REZ );

/* Start the show */
gl.start();
gl.fullscreen();
gl.animate();

audio.play();

setTimeout(function() {
	audio.pause();
}, 30000);

}, false );

function funkyClear() {
	  
	cdData = cd.data;
    
  t4 = p4;
  t3 = p3;

  i = SCROLLER_REZ; while(i--) {
    t1 = p1 + 5;
    t2 = p2 + 3;

    t3 &= 511;
    t4 &= 511;

    j = SCROLLER_REZ; while(j--) {
      t1 &= 511;
      t2 &= 511;

      x = aSin[t1] + aSin[t2] + aSin[t3] + aSin[t4];

      idx = (i + j * ig.width) * 4;
      
      cdData[idx] = x/as;
      cdData[idx + 1] = x/fd;
      cdData[idx + 2] = x/ps;
      cdData[idx + 3] = 255;
      
      t1 += 5;
      t2 += 3;
    }

    t4 += as1;
    t3 += fd1;
    
  }
    
  cd.data = cdData;    

  c2d.putImageData(cd, 0, 0);

  p1 += ps;
  p3 += ps2;
}

//var x = y = z = 0;
gl.ondraw = function() {
	gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);
	gl.loadIdentity();
		
	// set camera
	gl.translate(0, -0.33, -1.5 + (angle % 20)/140);
	
	//draw text
	funkyClear();
	//c2d.clearRect(0, 0, SCROLLER_REZ, SCROLLER_REZ);
	var scrollpos = (audio.currentTime/audio.duration) * SCROLLER_REZ * 14; 
	c2d.fillText(textString, SCROLLER_REZ-scrollpos, SCROLLER_REZ/2.5);
	var textTexture = GL.Texture.fromImage(textCanvas);
	textTexture.bind(0);
	textShader.uniforms({
		texture: 0
	}).draw(textMesh);
	
	// set camera
	gl.translate(0, 2, -10);
	
	//gl.rotate(30, 0, 1, 0);
	gl.rotate(angle, 0, 1, 0);
	
	//draw visualization
	var freqByteData = new Uint8Array(analyser.frequencyBinCount);
	analyser.getByteFrequencyData(freqByteData);
	
	var fcount = analyser.frequencyBinCount;
	/*
	gl.pointSize(10);
	var msize = fcount/20;
	for(var i=0; i<fcount-msize; i+=msize){
		gl.begin(gl.TRIANGLES);
		for(var j=0; j<msize; j++) {
			var db = freqByteData[i+j];
			gl.color(1, 1, j/msize); 
			gl.vertex(i/fcount, j/msize, db / 255);
		}
		gl.end();
	}
	*/
	var photoTexture = GL.Texture.fromImage(photocanvas);
	photoTexture.bind(1);

	gl.translate(0, -5, -15);
	for (var i=0; i<10; i++) {
	gl.translate(0, -10, 3);
		for (var j=0; j<10; j++) {
				gl.translate(0, 1, 0);
				var db = freqByteData[j % fcount];
				gl.translate(0, db / 20,0);
				var iy = (db / 200) / (i / 2);
				shader.uniforms({
					intensityB: iy * angle%10/6,
					intensityG: iy * (36-angle%10)/36,
					texture: 1
				}).draw(cube);
				gl.translate(0,-db / 20,0);
		}
	}
			//gl.color(1, 0, 0); 
			//gl.vertex(0, i*13, db / 200);	

};


}
