/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.av;

import com.jogamp.opengl.util.av.AudioSink;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class JavaSoundAudioSink
implements AudioSink {
    public static final int BUFFER_SIZE = 1000;
    public static final int SAMPLES_PER_BUFFER = 500;
    private static final boolean staticAvailable;
    private AudioFormat format;
    private DataLine.Info info;
    private SourceDataLine auline;
    private int bufferCount;
    private byte[] sampleData = new byte[1000];
    private boolean initialized = false;
    private AudioSink.AudioDataFormat chosenFormat = null;

    public String toString() {
        return "JavaSoundSink[init " + this.initialized + ", dataLine " + this.info + ", source " + this.auline + ", bufferCount " + this.bufferCount + ", chosen " + this.chosenFormat + ", jsFormat " + this.format;
    }

    @Override
    public AudioSink.AudioDataFormat getPreferredFormat() {
        return DefaultFormat;
    }

    @Override
    public AudioSink.AudioDataFormat initSink(AudioSink.AudioDataFormat audioDataFormat, int n) {
        if (!staticAvailable) {
            return null;
        }
        this.format = new AudioFormat(audioDataFormat.sampleRate, audioDataFormat.sampleSize, audioDataFormat.channelCount, audioDataFormat.signed, !audioDataFormat.littleEndian);
        this.info = new DataLine.Info(SourceDataLine.class, this.format);
        Arrays.fill(this.sampleData, (byte)0);
        try {
            this.auline = (SourceDataLine)AudioSystem.getLine(this.info);
            this.auline.open(this.format);
            this.auline.start();
            System.out.println("JavaSound audio sink");
            this.initialized = true;
            this.chosenFormat = audioDataFormat;
        }
        catch (Exception exception) {
            this.initialized = false;
        }
        return this.chosenFormat;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void destroy() {
        this.initialized = false;
        this.chosenFormat = null;
    }

    @Override
    public void writeData(AudioSink.AudioFrame audioFrame) {
        int n = audioFrame.dataSize;
        byte[] byArray = new byte[n];
        int n2 = audioFrame.data.position();
        audioFrame.data.get(byArray, 0, n);
        audioFrame.data.position(n2);
        int n3 = 0;
        while (n > 0) {
            int n4 = this.auline.write(byArray, n3, n);
            n -= n4;
            n3 += n4;
        }
    }

    @Override
    public int getQueuedByteCount() {
        return this.auline.available();
    }

    @Override
    public int getQueuedTime() {
        return 0;
    }

    @Override
    public int getWritableBufferCount() {
        return 1;
    }

    @Override
    public boolean isDataAvailable(int n) {
        return this.auline.available() >= n;
    }

    static {
        boolean bl = false;
        try {
            AudioSystem.getAudioFileTypes();
            bl = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        staticAvailable = bl;
    }
}

