import pygame, sys, random, Star, Utils, Text, Unicorn, Bepo, Thing
from pygame.locals import * 

pygame.init()

screen = pygame.display.set_mode((1280, 720))
pygame.display.set_caption("SpaceUnicorn!")
icon = pygame.image.load("images/icon.png")
colorkey = icon.get_at((0, 0))
icon.set_colorkey(colorkey, RLEACCEL)
pygame.display.set_icon(icon)

background = Utils.load_image('images/bg.png')
background = background.convert()

pygame.mixer.music.load('sound/Pitfall - Chaos.mp3')
pygame.mixer.music.play(-1)

sprites = pygame.sprite.LayeredUpdates()

clock = pygame.time.Clock()

def user_input(events):
    for event in events:
        if event.type == QUIT:
            pygame.quit()
            sys.exit(0)
        elif event.type == KEYDOWN:
            if event.key == K_ESCAPE:
                pygame.quit()
                sys.exit(0)
            elif event.key == K_f:
                pygame.display.set_mode((1280, 720), pygame.FULLSCREEN)

def spawn_star():
    y = random.randint(0, 720)
    size = random.randint(0, 1)
    speed = random.randint(1, 3)
    sprites.add(Star.Star((0, y), size, speed))

def spawn_thing():
    y = random.randint(0, 500)
    typ = random.randint(0, 3)
    
    if (typ == 0):
        sprites.add(Thing.Thing((-300, y), 'images/author.png'))
    elif (typ == 1):
        sprites.add(Thing.Thing((-300, y), 'images/planet.png'))
    elif (typ == 2):
        sprites.add(Thing.Thing((-300, y), 'images/moon.png'))
    elif (typ == 3):
        sprites.add(Thing.Thing((-300, y), 'images/peni.png'))

def run_demo():
    logo = False
    unicorn = False
    bepo = False
    cred = False
    at = False
    music = False
    greetz = False
    fade = False
    q = False
    
    frame = 0
    while True:
        clock.tick(60)
        if frame % 5 == 0:
            spawn_star()

        if frame % (4*60) == 0 and frame > (8*60):
            spawn_thing()
            
        if pygame.time.get_ticks() > 8*1000 and not logo:
            sprites.add(Text.Text((0,0), 'images/logo.png', 'images/logo2.png', 10))
            logo = True
            
        if pygame.time.get_ticks() > 18*1000 and not unicorn:
            sprites.add(Unicorn.Unicorn((1280,50)))
            unicorn = True
            
        if pygame.time.get_ticks() > 26*1000 and not bepo:
            sprites.add(Bepo.Bepo((1200,-131)))
            bepo = True

        if pygame.time.get_ticks() > 79*1000 and not cred:
            sprites.add(Text.Text((0,0), 'images/cred.png', 'images/cred2.png', 5))
            cred = True

        if pygame.time.get_ticks() > 84*1000 and not at:
            sprites.add(Text.Text((0,0), 'images/at.png', 'images/at2.png', 5))
            at = True

        if pygame.time.get_ticks() > 89*1000 and not music:
            sprites.add(Text.Text((0,0), 'images/music.png', 'images/music2.png', 5))
            music = True

        if pygame.time.get_ticks() > 95*1000 and not greetz:
            sprites.add(Text.Text((0,0), 'images/greetz.png', 'images/greetz2.png', 5))
            greetz = True
            
        if pygame.time.get_ticks() > 99*1000 and not fade:
            pygame.mixer.music.fadeout(2000)
            fade = True

        if pygame.time.get_ticks() > 104*1000 and not q:
            pygame.quit()
            sys.exit()
            
        frame += 1        
        user_input(pygame.event.get())
        
        sprites.update(sprites, screen)
        screen.blit(background, (0, 0))
        
        for sprite in sprites:
            sprite.draw(screen)
                
        pygame.display.flip()
    
run_demo()
