/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.esotericsoftware.kryonet.Client;
import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.Listener;
import fonts.Fonts;
import game.B23Client;
import game.Package;
import java.awt.Graphics;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;

public class JoinGame {
    ArrayList<Package.ServerInfo> serverInfos = new ArrayList();
    volatile boolean hasRecieved = false;
    JFrame frame;

    public JoinGame(B23Client b23Client, JFrame frame) {
        this.frame = frame;
        this.search();
    }

    public String update() {
        try {
            Thread.sleep(20L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void search() {
        Client client = new Client();
        Package.register(client);
        client.start();
        client.addListener(new Listener.ThreadedListener(new Listener(){

            @Override
            public void received(Connection connection, Object object) {
                if (object instanceof Package.ServerInfo) {
                    JoinGame.this.serverInfos.add((Package.ServerInfo)object);
                    JoinGame.this.hasRecieved = true;
                }
            }

            @Override
            public void disconnected(Connection connection) {
                System.err.println("disconnect from server");
            }
        }));
        List<InetAddress> addresses = client.discoverHosts(54777, 5000);
        int i = 0;
        while (i < addresses.size()) {
            try {
                client.connect(5000, addresses.get(i).getHostAddress(), Package.port, 54777);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.hasRecieved = false;
            client.sendTCP(new Package.RequestServerInfo());
            while (!this.hasRecieved) {
            }
            ++i;
        }
    }

    public void draw(Graphics g) {
        g.setColor(B23Client.GUI_PURPLE);
        g.fillRect(0, 0, this.frame.getWidth(), this.frame.getHeight());
        g.setColor(B23Client.GUI_GREEN);
        g.setFont(Fonts.c64size20);
        int i = 0;
        while (i < this.serverInfos.size()) {
            Package.ServerInfo si = this.serverInfos.get(i);
            g.drawString(String.valueOf(si.ip) + " players " + si.players, 100, 100 + i * 60);
            ++i;
        }
    }
}

