/*
 * Decompiled with CFR 0.152.
 */
package game;

import fonts.Fonts;
import game.B23Client;
import game.Dialog;
import game.Input;
import java.awt.Color;
import java.awt.Graphics;
import maps.MapInfo;

public class ChangeMapDialog
implements Dialog {
    int x;
    int y;
    int current;

    public ChangeMapDialog(int x, int y, B23Client b23client, Input input) {
        b23client.dialog = this;
        this.x = x;
        this.y = y;
        while (true) {
            input.update();
            if (input.isKeyPressed(input.ENTER)) break;
            input.getClass();
            if (input.isKeyPressed(40)) {
                ++this.current;
                if (this.current == MapInfo.MAPS.length) {
                    this.current = 0;
                }
            } else {
                input.getClass();
                if (input.isKeyPressed(38)) {
                    --this.current;
                    if (this.current == -1) {
                        this.current = MapInfo.MAPS.length - 1;
                    }
                }
            }
            b23client.repaint();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        b23client.dialog = null;
    }

    public int get() {
        return this.current;
    }

    @Override
    public void draw(Graphics g) {
        int w = 1000;
        int h = 700;
        g.translate(this.x, this.y);
        g.setColor(B23Client.GUI_PURPLE);
        g.fillRect(0, 0, w, h);
        g.setColor(Color.black);
        g.drawRect(0, 0, w, h);
        int i = 0;
        while (i < MapInfo.MAPS.length) {
            MapInfo.MapType m = MapInfo.MAPS[i];
            if (i == this.current) {
                g.setFont(Fonts.c64size50);
                g.setColor(Color.black);
                g.drawString(MapInfo.getMapName(m), 38, 60 + i * 60 - 5 + 3);
                g.setColor(B23Client.GUI_GREEN);
                g.drawString(MapInfo.getMapName(m), 35, 60 + i * 60 - 5);
                g.drawImage(MapInfo.getMapImage(m), 600, 300, 350, 350, null);
            } else {
                g.setFont(Fonts.c64size40);
                g.setColor(Color.black);
                g.drawString(MapInfo.getMapName(m), 43, 60 + i * 60 + 3);
                g.setColor(B23Client.GUI_GREEN);
                g.drawString(MapInfo.getMapName(m), 40, 60 + i * 60);
            }
            ++i;
        }
        g.translate(-this.x, -this.y);
    }
}

