/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.esotericsoftware.kryonet.Client;
import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.Listener;
import com.esotericsoftware.minlog.Log;
import fonts.Fonts;
import game.B23Server;
import game.Dialog;
import game.ExitDialog;
import game.Game;
import game.Input;
import game.InputDialog;
import game.Intro;
import game.JoinGame;
import game.Lobby;
import game.MainMenu;
import game.Package;
import game.Settings;
import game.StartScreen;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import orders.Order;
import sound.Sound;
import utils.LimitedQueue;

public class B23Client
extends JPanel {
    private Client client;
    private int myPlayerID;
    private Game game;
    private Input input;
    private ArrayList<Order[]> currentPlayerOrders;
    public static final int localSimulations = 10;
    public static final Color GUI_GREEN = new Color(150, 230, 30);
    public static final Color GUI_PURPLE = new Color(230, 30, 200);
    private int localSimulationsCounter = 0;
    private JFrame frame;
    private long lastServerPackageTime;
    private long currentServerPackageTime;
    private final int STATE_LOBBY = 1;
    private final int STATE_GAME = 2;
    private final int STATE_INTRO = 3;
    private final int STATE_MAIN_MENU = 4;
    private final int STATE_JOIN_GAME = 5;
    private final int STATE_AFTER_GAME = 6;
    private int currentState = 3;
    private Package.LobbyPlayerServerPackage[] lobbyPlayers;
    ArrayList<Package.ChatMessage> chatMessages = new ArrayList();
    private Package.ClientLobbyPackage myLatestLobbyPackage = new Package.ClientLobbyPackage();
    private String myName = "NO_NAME";
    private boolean firstTimeGameSetupDone = false;
    private Intro intro;
    private MainMenu mainMenu;
    private JoinGame joinGame;
    private Lobby lobby;
    private long gameStateT0 = 0L;
    private long gameStateTime = 0L;
    private BufferedImage graphicsBuffer = new BufferedImage(2500, 2500, 1);
    private LimitedQueue<Integer> simulationTimeStats = new LimitedQueue(500);
    private LimitedQueue<Integer> graphicsTimeStats = new LimitedQueue<Integer>(500, 0);
    private ReentrantLock localSimulationsFinishedLock = new ReentrantLock();
    private boolean isHost = false;
    public Sound sound;
    public Dialog dialog;
    public int map;
    private B23Server server;
    private String winnerName;
    private double lastRot = 0.0;
    private double dRot = 0.1;
    private int portNum = -1;
    private String myIP;
    private long lastSimulationTime = -1L;
    private volatile boolean painted = false;
    private volatile boolean simulationFinished = true;

    public static void main(String[] args) {
        Log.set(3);
        new B23Client();
    }

    public B23Client() {
        this.myLatestLobbyPackage.playerID = this.myPlayerID;
        this.initFrame();
        this.myIP = "UNKOWN IP";
        try {
            this.myIP = String.valueOf(InetAddress.getLocalHost().getHostAddress()) + " (local) ";
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        this.intro = new Intro(this.frame);
        this.input = new Input(this.frame, !this.frame.isUndecorated());
        this.mainMenu = new MainMenu(this.input, this.frame, this.sound);
        this.loop();
    }

    private void initClient(boolean localHost) {
        this.isHost = localHost;
        this.client = new Client();
        Package.register(this.client);
        this.client.start();
        this.client.addListener(new Listener.ThreadedListener(new Listener(){

            @Override
            public void received(Connection connection, Object object) {
                B23Client.this.processServerPackage(object);
            }

            @Override
            public void disconnected(Connection connection) {
                System.err.println("disconnect from server");
                System.exit(1);
            }
        }));
        String ip = "IP";
        if (localHost) {
            ip = "127.0.0.1";
        } else {
            InetAddress address = this.client.discoverHost(54777, 2000);
            System.out.println("host discovery: " + address);
            ip = new InputDialog("Host IP:", address == null ? "" : address.getHostAddress(), this, this.frame, this.input, this.frame.getWidth() / 2 - 400, this.frame.getHeight() / 2 - 100).get();
        }
        try {
            this.client.connect(5000, ip, this.portNum, 54777);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(null, "Could not connect, exiting");
            System.exit(1);
        }
    }

    private void processServerPackage(Object object) {
        if (object instanceof Package.ConnectionPackage) {
            Package.ConnectionPackage cp = (Package.ConnectionPackage)object;
            this.myPlayerID = cp.playerID;
            this.game = new Game(this.myPlayerID, this.input, cp.simulationSeed, this.frame, this.sound);
        }
        if (object instanceof Package.ServerPackage) {
            while (!this.simulationFinished) {
            }
            this.simulationFinished = false;
            this.localSimulationsFinishedLock.lock();
            long milliTime = System.currentTimeMillis();
            this.currentServerPackageTime = milliTime - this.lastServerPackageTime;
            this.lastServerPackageTime = milliTime;
            Package.ServerPackage sp = (Package.ServerPackage)object;
            this.currentPlayerOrders = sp.playerOrders;
            this.localSimulationsCounter = 0;
            if (!this.firstTimeGameSetupDone) {
                this.game.initSimulation(this.lobbyPlayers, this.map);
                this.firstTimeGameSetupDone = true;
                this.currentState = 2;
            }
            this.localSimulationsFinishedLock.unlock();
        }
        if (object instanceof Package.LobbyServerPackage) {
            Package.LobbyServerPackage lsp = (Package.LobbyServerPackage)object;
            this.addNewChatMessages(lsp.newMessages);
            this.lobbyPlayers = lsp.players;
            if (lsp.map != -1) {
                this.map = lsp.map;
            }
        }
    }

    private void addNewChatMessages(Package.ChatMessage[] newMessages) {
        if (newMessages != null) {
            int i = 0;
            while (i < newMessages.length) {
                this.chatMessages.add(newMessages[i]);
                ++i;
            }
        }
    }

    public void loop() {
        new Thread(){

            @Override
            public void run() {
                while (true) {
                    B23Client.this.repaint();
                    try {
                        Thread.sleep(1L);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        }.start();
        block20: while (true) {
            this.input.update();
            this.input.getClass();
            if (this.input.isKeyDown(27)) {
                this.askForExit();
            }
            switch (this.currentState) {
                case 2: {
                    boolean wait;
                    this.gameStateT0 = System.currentTimeMillis();
                    this.sound.setMusic(Sound.GAME_MUSIC);
                    boolean first = this.localSimulationsCounter == 0;
                    boolean last = this.localSimulationsCounter == 9;
                    boolean bl = wait = this.localSimulationsCounter > 9;
                    if (!wait) {
                        long ctm;
                        if (first) {
                            this.game.simulate(this.currentPlayerOrders);
                            ctm = System.currentTimeMillis();
                            this.simulationTimeStats.add((int)(ctm - this.lastSimulationTime));
                            this.lastSimulationTime = ctm;
                            ++this.localSimulationsCounter;
                            this.sendCurrentOrders();
                        } else {
                            this.game.simulate(new ArrayList<Order[]>());
                            ctm = System.currentTimeMillis();
                            this.simulationTimeStats.add((int)(ctm - this.lastSimulationTime));
                            this.lastSimulationTime = ctm;
                            ++this.localSimulationsCounter;
                        }
                        int winnerID = this.game.gameOver();
                        if (winnerID >= 0) {
                            int i = 0;
                            while (i < this.lobbyPlayers.length) {
                                if (this.lobbyPlayers[i].playerID == winnerID) {
                                    this.winnerName = this.lobbyPlayers[i].name;
                                }
                                ++i;
                            }
                            this.currentState = 6;
                        }
                        if (last) {
                            this.localSimulationsFinishedLock.isLocked();
                            this.simulationFinished = true;
                        }
                        if (this.simulationTimeStats.size() != 0) {
                            int desiredTime = 10;
                            int lastTime = (int)(this.gameStateT0 - System.currentTimeMillis());
                            if (lastTime < desiredTime) {
                                int sleep = desiredTime - lastTime;
                                try {
                                    Thread.sleep(sleep);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                    if (this.game != null) {
                        this.game.update();
                    }
                    this.gameStateTime = System.currentTimeMillis() - this.gameStateT0;
                    continue block20;
                }
                case 1: {
                    this.sound.setMusic(Sound.MENU_MUSIC);
                    if (this.lobby == null) {
                        this.lobby = new Lobby();
                    }
                    try {
                        if (this.client != null) {
                            this.client.update(1);
                        }
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    this.myName = this.lobby.update(this.myLatestLobbyPackage, this.input, this.myName, this.myPlayerID, this.isHost, this, this.lobbyPlayers);
                    this.sendLobbyPackage();
                    continue block20;
                }
                case 3: {
                    this.sound.setMusic(Sound.MENU_MUSIC);
                    if (this.input.isAnyKeyDown()) {
                        this.currentState = 4;
                    }
                    this.intro.update();
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue block20;
                }
                case 4: {
                    MainMenu.Action action = this.mainMenu.update();
                    switch (action) {
                        case EXIT: {
                            this.askForExit();
                            continue block20;
                        }
                        case HOST_GAME: {
                            this.hostGame();
                            continue block20;
                        }
                        case JOIN_GAME: {
                            this.currentState = 5;
                            continue block20;
                        }
                        case NO_ACTION: {
                            continue block20;
                        }
                    }
                    continue block20;
                }
                case 5: {
                    this.joinGame();
                    continue block20;
                }
                case 6: {
                    this.sound.stopMusic();
                    if (!this.input.isKeyPressed(this.input.ENTER)) {
                        this.input.getClass();
                        if (!this.input.isKeyPressed(32)) continue block20;
                    }
                    this.client.stop();
                    this.client.close();
                    if (this.server != null) {
                        this.server.stopAndClose();
                        this.server = null;
                    }
                    JOptionPane.showMessageDialog(null, "Thanks for playing, cya");
                    System.exit(0);
                    continue block20;
                }
            }
            System.err.println("Unknown state in main loop: " + this.currentState);
        }
    }

    private void askForExit() {
        new ExitDialog(this, this.frame, this.input);
    }

    private void joinGame() {
        this.currentState = 1;
        this.initClient(false);
    }

    private void hostGame() {
        this.currentState = 1;
        new Thread(){

            @Override
            public void run() {
                B23Client.this.server = new B23Server(false, B23Client.this.portNum);
            }
        }.start();
        this.initClient(true);
    }

    private void sendLobbyPackage() {
        this.client.sendTCP(this.myLatestLobbyPackage);
        this.myLatestLobbyPackage = new Package.ClientLobbyPackage();
        this.myLatestLobbyPackage.playerID = this.myPlayerID;
    }

    private void sendCurrentOrders() {
        Package.ClientPackage cp = new Package.ClientPackage();
        cp.orders = this.game.popOrders();
        cp.playerID = this.myPlayerID;
        cp.simulationNumber = this.game.simulationNumber;
        this.client.sendTCP(cp);
    }

    public void initFrame() {
        StartScreen ss = new StartScreen();
        this.frame = ss.init(this);
        this.sound = new Sound(ss.soundVolume, ss.musicVolume);
        this.portNum = ss.getPort();
    }

    String getPlayerName(int playerID) {
        int i = 0;
        while (i < this.lobbyPlayers.length) {
            if (this.lobbyPlayers[i].playerID == playerID) {
                return this.lobbyPlayers[i].name;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void paint(Graphics g) {
        if (this.dialog != null) {
            this.dialog.draw(g);
            return;
        }
        this.graphicsTimeStats.add((int)System.currentTimeMillis());
        g.setColor(Color.black);
        g.fillRect(0, 0, 2500, 2500);
        switch (this.currentState) {
            case 2: {
                int val;
                int i;
                int c;
                if (this.game != null) {
                    this.game.draw(g);
                    if (Settings.DRAW_GAME_DEBUG_INFO) {
                        this.game.drawDebugInfo(g, 20, 200);
                    }
                }
                if (Settings.DEBUG_DRAW_CLIENTINFROMATION) {
                    g.setColor(Color.white);
                    g.drawString("PlayerID: " + this.myPlayerID, 20, 20);
                    g.drawString("Local simulations counter: " + this.localSimulationsCounter, 20, 40);
                    g.drawString("\"PING\": " + this.currentServerPackageTime, 20, 60);
                    g.drawString("Game state time: " + this.gameStateTime, 20, 80);
                }
                if (Settings.DEBUG_DRAW_LAG_DETECTOR) {
                    g.setColor(Color.cyan);
                    g.fillRect(10 * this.game.getSimulationNumber() % 1000, 0, 10, 100);
                }
                if (Settings.DEBUG_SIMULATION_FPS_STATS) {
                    g.setColor(Color.red);
                    c = 0;
                    i = 0;
                    while (i < this.simulationTimeStats.size()) {
                        val = -10;
                        try {
                            val = (Integer)this.simulationTimeStats.get(i);
                        }
                        catch (Exception e) {
                            System.out.println("DEBUG_SIMULATION_FPS_STATS: " + e.getMessage());
                        }
                        g.drawLine(++c, this.frame.getHeight() - 50, c, this.frame.getHeight() - 50 - val);
                        ++i;
                    }
                    g.setColor(Color.white);
                    g.drawLine(0, this.frame.getHeight() - 50, 500, this.frame.getHeight() - 50);
                    g.drawLine(0, this.frame.getHeight() - 50 - 50, 500, this.frame.getHeight() - 50 - 50);
                }
                if (!Settings.DEBUG_GRAPHICS_STATS) break;
                g.setColor(Color.yellow);
                c = 500;
                i = 1;
                while (i < this.graphicsTimeStats.size()) {
                    val = -10;
                    try {
                        val = (Integer)this.graphicsTimeStats.get(i) - (Integer)this.graphicsTimeStats.get(i - 1);
                    }
                    catch (Exception e) {
                        System.out.println("DEBUG_GRAPHICS_STATS: " + e.getMessage());
                    }
                    g.drawLine(++c, this.frame.getHeight() - 50, c, this.frame.getHeight() - 50 - val);
                    ++i;
                }
                g.setColor(Color.white);
                g.drawLine(0, this.frame.getHeight() - 50, c, this.frame.getHeight() - 50);
                g.drawLine(0, this.frame.getHeight() - 50 - 50, c, this.frame.getHeight() - 50 - 50);
                break;
            }
            case 1: {
                if (this.lobby == null) break;
                this.lobby.draw(g, this.lobbyPlayers, this.chatMessages, this, this.frame, this.portNum, this.myIP);
                break;
            }
            case 3: {
                if (this.intro == null) break;
                this.intro.draw(g);
                break;
            }
            case 4: {
                this.mainMenu.draw(g);
                break;
            }
            case 5: {
                if (this.joinGame == null) break;
                this.joinGame.draw(g);
                break;
            }
            case 6: {
                g.setColor(GUI_PURPLE);
                g.fillRect(0, 0, this.frame.getWidth(), this.frame.getHeight());
                g.setFont(Fonts.c64size100);
                g.setColor(Color.BLACK);
                Graphics2D g2d = (Graphics2D)g;
                g2d.translate(this.frame.getWidth() / 2, this.frame.getHeight() / 2);
                double newRot = this.lastRot + this.dRot;
                this.dRot *= 0.99601;
                g2d.rotate(newRot);
                this.lastRot = newRot;
                if (this.dRot == 2.4468253844561023E-4) {
                    this.sound.playSound(Sound.VICTORY);
                }
                g2d.translate(-this.frame.getWidth() / 2, -this.frame.getHeight() / 2);
                String winnerString = "Winner: " + this.winnerName;
                int wSiz = winnerString.length() * 80;
                g.drawString(winnerString, this.frame.getWidth() / 2 + 10 - wSiz / 2, this.frame.getHeight() / 2 + 10);
                g.setColor(GUI_GREEN);
                g.drawString(winnerString, this.frame.getWidth() / 2 - wSiz / 2, this.frame.getHeight() / 2);
                break;
            }
            default: {
                System.err.println("Unknown state in paint: " + this.currentState);
            }
        }
        if (Settings.DEBUG_DRAW_SCREEN_SIZE_1024_768) {
            g.setColor(Color.white);
            g.setXORMode(Color.black);
            g.drawRect(0, 0, 1024, 768);
        }
        if (Settings.DEBUG_DRAW_SCREEN_SIZE_1280_720) {
            g.setColor(Color.white);
            g.setXORMode(Color.black);
            g.drawRect(0, 0, 1280, 720);
        }
    }

    public JFrame getFrame() {
        return this.frame;
    }
}

