/*
 * Decompiled with CFR 0.152.
 */
package entities.projectiles;

import entities.Entity;
import entities.units.Unit;
import game.Game;
import java.awt.Graphics;
import java.util.ArrayList;
import utils.Vec2;

public abstract class Projectile
extends Entity {
    protected int myUnitID;
    protected int myPlayerID;
    protected double speed = 15.0;
    protected Vec2 speeds;
    protected Game game;
    protected double damage = 5.0;

    public Projectile(int myPlayerID, int myUnitID, Vec2 startPos, Game game) {
        this.game = game;
        this.myPlayerID = myPlayerID;
        this.myUnitID = myUnitID;
        this.pos = startPos.clone();
        this.size = 10;
    }

    public void simulate() {
        if (this.pos.x < 0.0 || this.pos.x > (double)this.game.map.getWidth() || this.pos.y < 0.0 || this.pos.y > (double)this.game.map.getHeight()) {
            this.shallBeRemoved = true;
        }
        this.pos.x += this.speeds.x;
        this.pos.y += this.speeds.y;
        ArrayList<Unit> units = this.game.map.getUnitsFromAdjecentTiles(this);
        int i = 0;
        while (i < units.size()) {
            Unit u = units.get(i);
            if (u.myPlayerID != this.myPlayerID && this.collides(u)) {
                u.takeDamage(this.damage);
                this.shallBeRemoved = true;
            }
            ++i;
        }
    }

    public abstract void draw(Graphics var1);
}

