/*
 * Decompiled with CFR 0.152.
 */
package effects;

import effects.Effect;
import entities.units.Unit;
import game.Game;
import java.awt.Color;
import java.awt.Graphics;
import utils.Vec2;

public class BuildSpray
implements Effect {
    int HALF_SIZE = 2;
    double speed = 3.0;
    Vec2 pos;
    Vec2 speeds;
    int time;
    public static final Color BUILD_SPRAY_COLOR = new Color(41, 254, 116);

    public BuildSpray(Unit builder, Unit buildTarget) {
        double diff = (double)buildTarget.size / 2.0;
        Vec2 target = buildTarget.pos.translateClone(Math.random() * diff - diff / 2.0, Math.random() * diff - diff / 2.0);
        double angle = Game.angleFromTo(builder.pos, target);
        this.pos = builder.getBuildSprayOrigin();
        this.speeds = new Vec2(this.speed * Math.cos(angle), this.speed * Math.sin(angle));
        this.time = (int)(this.pos.disTo(target) / this.speed);
    }

    @Override
    public boolean isFinsihed() {
        return this.time < 0;
    }

    @Override
    public void simulate() {
        this.pos.move(this.speeds);
        --this.time;
    }

    @Override
    public void draw(Graphics g) {
        g.setColor(BUILD_SPRAY_COLOR);
        g.fillRect((int)this.pos.x - this.HALF_SIZE, (int)this.pos.y - this.HALF_SIZE, this.HALF_SIZE * 2, this.HALF_SIZE * 2);
    }

    @Override
    public boolean isOnHud() {
        return false;
    }
}

