/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.jsonbeans;

import com.esotericsoftware.jsonbeans.ObjectMap;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedMap<K, V>
extends ObjectMap<K, V> {
    final ArrayList<K> keys;

    public OrderedMap() {
        this.keys = new ArrayList();
    }

    public OrderedMap(int n) {
        super(n);
        this.keys = new ArrayList(n);
    }

    public OrderedMap(int n, float f) {
        super(n, f);
        this.keys = new ArrayList(n);
    }

    @Override
    public V put(K k, V v) {
        if (!this.containsKey(k)) {
            this.keys.add(k);
        }
        return super.put(k, v);
    }

    @Override
    public V remove(K k) {
        this.keys.remove(k);
        return super.remove(k);
    }

    @Override
    public void clear() {
        this.keys.clear();
        super.clear();
    }

    public ArrayList<K> orderedKeys() {
        return this.keys;
    }

    @Override
    public ObjectMap.Entries<K, V> entries() {
        return new ObjectMap.Entries(this){

            protected void advance() {
                ++this.nextIndex;
                this.hasNext = this.nextIndex < this.map.size;
            }

            public ObjectMap.Entry next() {
                this.entry.key = OrderedMap.this.keys.get(this.nextIndex);
                this.entry.value = this.map.get(this.entry.key);
                this.advance();
                return this.entry;
            }

            public void remove() {
                this.map.remove(this.entry.key);
            }
        };
    }

    @Override
    public ObjectMap.Keys<K> keys() {
        return new ObjectMap.Keys(this){

            @Override
            protected void advance() {
                ++this.nextIndex;
                this.hasNext = this.nextIndex < this.map.size;
            }

            @Override
            public K next() {
                Object k = OrderedMap.this.keys.get(this.nextIndex);
                this.advance();
                return k;
            }

            @Override
            public void remove() {
                this.map.remove(OrderedMap.this.keys.get(this.nextIndex - 1));
            }
        };
    }

    @Override
    public ObjectMap.Values<V> values() {
        return new ObjectMap.Values(this){

            @Override
            protected void advance() {
                ++this.nextIndex;
                this.hasNext = this.nextIndex < this.map.size;
            }

            @Override
            public V next() {
                Object v = this.map.get(OrderedMap.this.keys.get(this.nextIndex));
                this.advance();
                return v;
            }

            @Override
            public void remove() {
                this.map.remove(OrderedMap.this.keys.get(this.nextIndex - 1));
            }
        };
    }

    @Override
    public String toString() {
        if (this.size == 0) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('{');
        ArrayList<K> arrayList = this.keys;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            K k = arrayList.get(i);
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(k);
            stringBuilder.append('=');
            stringBuilder.append(this.get(k));
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

