/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.scene;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.utils.Disposable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.taongad.anim.AnimationSequence;

public abstract class Scene
implements Disposable {
    Logger log = Logger.getLogger(Scene.class.getName());
    List<Disposable> disposables = new ArrayList<Disposable>();
    SpriteBatch batch;
    protected float time;
    protected final int LOWRES_TEX_W = 128;
    protected final int LOWRES_TEX_H = 72;
    protected AnimationSequence anim;
    final int SCREEN_W = Gdx.graphics.getWidth();
    final int SCREEN_H = Gdx.graphics.getHeight();
    final int SCREEN_W_HALF = this.SCREEN_W / 2;
    final int SCREEN_H_HALF = this.SCREEN_H / 2;

    public abstract void load();

    public void update(float deltaTimeMSec) {
        if (this.anim != null) {
            this.anim.update(deltaTimeMSec);
        }
    }

    public abstract void draw(float var1);

    @Override
    public void dispose() {
        for (Disposable disposable : this.disposables) {
            this.log.info("Disposing: " + disposable.getClass().getName());
            disposable.dispose();
        }
    }
}

