/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.scene;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.math.MathUtils;
import org.taongad.scene.Scene;

public class RasterBarScene
extends Scene {
    Texture rasterTex_red;
    Texture rasterTex_green;
    Texture rasterTex_blue;
    Texture rasterTex_yellow;
    Texture rasterTex_purple;
    BitmapFont font;
    float scrollerX;
    float scrollerY;
    final String scrollerText = "Hello people at Birdie 23! We here in TAONGAD - \"The Art Of Never Getting Anything Done\" - would like to congratulate the Birdie crew on 20 years of scene activity in Uppsala! This is our first release at Birdie, and an homage to the old scene, but we hope that it will inspire the ever shrinking scene to beat the trend and grow. Here is to hoping a new breed of sceners will continue where the old scene left off. Hipp Hipp, Hurra!";

    @Override
    public void load() {
        this.batch = new SpriteBatch();
        this.rasterTex_red = this.generateRasterBar(Gdx.files.internal("gfx/rasterbar_red.png"));
        this.rasterTex_green = this.generateRasterBar(Gdx.files.internal("gfx/rasterbar_green.png"));
        this.rasterTex_blue = this.generateRasterBar(Gdx.files.internal("gfx/rasterbar_blue.png"));
        this.rasterTex_yellow = this.generateRasterBar(Gdx.files.internal("gfx/rasterbar_yellow.png"));
        this.rasterTex_purple = this.generateRasterBar(Gdx.files.internal("gfx/rasterbar_purple.png"));
        FreeTypeFontGenerator generator = new FreeTypeFontGenerator(Gdx.files.internal("fonts/BIRTH_OF_A_HERO.ttf"));
        this.font = generator.generateFont(68);
        generator.dispose();
    }

    private Texture generateRasterBar(FileHandle rasterFile) {
        Pixmap rasterTile = new Pixmap(rasterFile);
        Pixmap rasterBar = new Pixmap(Gdx.graphics.getWidth(), rasterTile.getHeight(), Pixmap.Format.RGB888);
        int x = 0;
        while (x < Gdx.graphics.getWidth()) {
            rasterBar.drawPixmap(rasterTile, x, 0);
            x += rasterTile.getWidth();
        }
        Texture rasterTex = new Texture(rasterBar);
        rasterBar.dispose();
        rasterTile.dispose();
        this.disposables.add(rasterTex);
        return rasterTex;
    }

    @Override
    public void draw(float deltaTimeMSec) {
        Gdx.gl.glClear(16384);
        this.time += deltaTimeMSec;
        float timeScale = 5.0E-4f;
        float offset = 200.0f;
        float wave1 = MathUtils.sin(this.time * timeScale * (float)Math.PI);
        float wave2 = MathUtils.sin((this.time - offset * 1.5f) * timeScale * (float)Math.PI);
        float wave3 = MathUtils.sin((this.time - offset * 3.0f) * timeScale * (float)Math.PI);
        float wave4 = MathUtils.sin((this.time - offset * 5.0f) * timeScale * (float)Math.PI);
        float wave5 = MathUtils.sin((this.time - offset * 7.0f) * timeScale * (float)Math.PI);
        float scrollWave = Math.abs(MathUtils.sin(this.time * timeScale * (float)Math.PI));
        float timeScrollScale = 0.3f;
        this.batch.begin();
        float tint = 0.3f;
        float barHeightOfScreen = 0.65f;
        this.batch.setColor(tint, tint, tint, 1.0f);
        this.batch.draw(this.rasterTex_purple, 0.0f, (float)this.SCREEN_H * barHeightOfScreen - (float)(this.rasterTex_purple.getHeight() / 2) - (float)this.rasterTex_green.getHeight() * wave5 * 3.5f);
        tint = 0.5f;
        this.batch.setColor(tint, tint, tint, 1.0f);
        this.batch.draw(this.rasterTex_yellow, 0.0f, (float)this.SCREEN_H * barHeightOfScreen - (float)(this.rasterTex_yellow.getHeight() / 2) - (float)this.rasterTex_green.getHeight() * wave4 * 3.5f);
        tint = 0.7f;
        this.batch.setColor(tint, tint, tint, 1.0f);
        this.batch.draw(this.rasterTex_blue, 0.0f, (float)this.SCREEN_H * barHeightOfScreen - (float)(this.rasterTex_blue.getHeight() / 2) - (float)this.rasterTex_green.getHeight() * wave3 * 3.5f);
        tint = 0.85f;
        this.batch.setColor(tint, tint, tint, 1.0f);
        this.batch.draw(this.rasterTex_green, 0.0f, (float)this.SCREEN_H * barHeightOfScreen - (float)(this.rasterTex_green.getHeight() / 2) - (float)this.rasterTex_green.getHeight() * wave2 * 3.5f);
        tint = 1.0f;
        this.batch.setColor(tint, tint, tint, 1.0f);
        this.batch.draw(this.rasterTex_red, 0.0f, (float)this.SCREEN_H * barHeightOfScreen - (float)(this.rasterTex_red.getHeight() / 2) - (float)this.rasterTex_green.getHeight() * wave1 * 3.5f);
        this.font.setColor(Color.WHITE);
        this.font.draw(this.batch, "Hello people at Birdie 23! We here in TAONGAD - \"The Art Of Never Getting Anything Done\" - would like to congratulate the Birdie crew on 20 years of scene activity in Uppsala! This is our first release at Birdie, and an homage to the old scene, but we hope that it will inspire the ever shrinking scene to beat the trend and grow. Here is to hoping a new breed of sceners will continue where the old scene left off. Hipp Hipp, Hurra!", (float)this.SCREEN_W - this.time * timeScrollScale, 60.0f + 180.0f * scrollWave);
        this.batch.end();
    }
}

