/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.IntArray;
import java.util.Comparator;

public class DelayedRemovalArray<T>
extends Array<T> {
    private boolean iterating;
    private IntArray remove = new IntArray(0);

    public DelayedRemovalArray() {
    }

    public DelayedRemovalArray(Array array) {
        super(array);
    }

    public DelayedRemovalArray(boolean ordered, int capacity, Class<T> arrayType) {
        super(ordered, capacity, arrayType);
    }

    public DelayedRemovalArray(boolean ordered, int capacity) {
        super(ordered, capacity);
    }

    public DelayedRemovalArray(boolean ordered, T[] array) {
        super(ordered, array);
    }

    public DelayedRemovalArray(Class<T> arrayType) {
        super(arrayType);
    }

    public DelayedRemovalArray(int capacity) {
        super(capacity);
    }

    public DelayedRemovalArray(T[] array) {
        super(array);
    }

    public void begin() {
        this.iterating = true;
    }

    public void end() {
        this.iterating = false;
        int n = this.remove.size;
        for (int i = 0; i < n; ++i) {
            this.removeIndex(this.remove.pop());
        }
    }

    private void remove(int index) {
        int n = this.remove.size;
        for (int i = 0; i < n; ++i) {
            int removeIndex = this.remove.get(i);
            if (index == removeIndex) {
                return;
            }
            if (index >= removeIndex) continue;
            this.remove.insert(i, index);
            return;
        }
        this.remove.add(index);
    }

    @Override
    public boolean removeValue(T value, boolean identity) {
        if (this.iterating) {
            int index = this.indexOf(value, identity);
            if (index == -1) {
                return false;
            }
            this.remove(index);
            return true;
        }
        return super.removeValue(value, identity);
    }

    @Override
    public T removeIndex(int index) {
        if (this.iterating) {
            this.remove(index);
            return this.get(index);
        }
        return super.removeIndex(index);
    }

    @Override
    public void set(int index, T value) {
        if (this.iterating) {
            throw new IllegalStateException("Invalid between begin/end.");
        }
        super.set(index, value);
    }

    @Override
    public void insert(int index, T value) {
        if (this.iterating) {
            throw new IllegalStateException("Invalid between begin/end.");
        }
        super.insert(index, value);
    }

    @Override
    public void swap(int first, int second) {
        if (this.iterating) {
            throw new IllegalStateException("Invalid between begin/end.");
        }
        super.swap(first, second);
    }

    @Override
    public T pop() {
        if (this.iterating) {
            throw new IllegalStateException("Invalid between begin/end.");
        }
        return super.pop();
    }

    @Override
    public void clear() {
        if (this.iterating) {
            throw new IllegalStateException("Invalid between begin/end.");
        }
        super.clear();
    }

    @Override
    public void sort() {
        if (this.iterating) {
            throw new IllegalStateException("Invalid between begin/end.");
        }
        super.sort();
    }

    @Override
    public void sort(Comparator<T> comparator) {
        if (this.iterating) {
            throw new IllegalStateException("Invalid between begin/end.");
        }
        super.sort(comparator);
    }

    @Override
    public void reverse() {
        if (this.iterating) {
            throw new IllegalStateException("Invalid between begin/end.");
        }
        super.reverse();
    }

    @Override
    public void shuffle() {
        if (this.iterating) {
            throw new IllegalStateException("Invalid between begin/end.");
        }
        super.shuffle();
    }

    @Override
    public void truncate(int newSize) {
        if (this.iterating) {
            throw new IllegalStateException("Invalid between begin/end.");
        }
        super.truncate(newSize);
    }
}

