/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.loaders.g3d.chunks;

import com.badlogic.gdx.graphics.g3d.loaders.g3d.chunks.CountingDataInputStream;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class ChunkReader {
    public static Chunk readChunks(InputStream in) throws IOException {
        return ChunkReader.loadChunks(in, 0);
    }

    private static Chunk loadChunks(InputStream in, int fileSize) throws IOException {
        byte[] bytes = ChunkReader.readStream(in, fileSize);
        CountingDataInputStream din = new CountingDataInputStream(new ByteArrayInputStream(bytes));
        return ChunkReader.loadChunk(din, bytes);
    }

    private static Chunk loadChunk(CountingDataInputStream din, byte[] bytes) throws IOException {
        int id = din.readInt();
        int payloadSize = din.readInt();
        int numChildren = din.readInt();
        int offset = din.getReadBytes();
        din.skipBytes(payloadSize);
        Chunk chunk = new Chunk(id, null, bytes, offset, payloadSize);
        for (int i = 0; i < numChildren; ++i) {
            Chunk child = ChunkReader.loadChunk(din, bytes);
            child.parent = chunk;
            chunk.children.add(child);
        }
        return chunk;
    }

    private static byte[] readStream(InputStream in, int size) throws IOException {
        if (size == 0) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            byte[] buffer = new byte[10240];
            int readBytes = 0;
            while ((readBytes = in.read(buffer)) != -1) {
                bytes.write(buffer, 0, readBytes);
            }
            return bytes.toByteArray();
        }
        byte[] bytes = new byte[size];
        DataInputStream din = new DataInputStream(in);
        din.readFully(bytes);
        return bytes;
    }

    public static void printChunks(Chunk chunk) {
        ChunkReader.printChunks(chunk, 0);
    }

    private static void printChunks(Chunk chunk, int level) {
        String id = null;
        String payload = null;
        switch (chunk.getId()) {
            case 1194542106: {
                id = "G3D_ROOT";
                break;
            }
            case 1: {
                id = "VERSION_INFO";
                int major = chunk.readByte();
                int minor = chunk.readByte();
                payload = ChunkReader.rep("   ", level + 1) + "major: " + major + ", minor: " + minor;
                break;
            }
            case 4096: {
                id = "STILL_MODEL";
                int subMeshes = chunk.readInt();
                payload = ChunkReader.rep("   ", level + 1) + "#submeshes: " + subMeshes;
                break;
            }
            case 4352: {
                id = "STILL_SUBMESH";
                payload = ChunkReader.rep("   ", level + 1) + "name: " + chunk.readString() + ", primitive type: " + chunk.readInt();
                break;
            }
            case 4385: {
                id = "VERTEX_ATTRIBUTE";
                int usage = chunk.readInt();
                int components = chunk.readInt();
                String name = chunk.readString();
                payload = ChunkReader.rep("   ", level + 1) + "usage: " + usage + ", components: " + components + ", name: " + name;
                break;
            }
            case 4384: {
                id = "VERTEX_ATTRIBUTES";
                int numAttributes = chunk.readInt();
                payload = ChunkReader.rep("   ", level + 1) + "#attributes: " + numAttributes;
                break;
            }
            case 4368: {
                id = "VERTEX_LIST";
                int numVertices = chunk.readInt();
                float[] vertices = chunk.readFloats();
                payload = ChunkReader.rep("   ", level + 1) + "#vertices: " + numVertices + ": " + Arrays.toString(vertices).substring(0, 400);
                break;
            }
            case 4369: {
                id = "INDEX_LIST";
                int numIndices = chunk.readInt();
                short[] indices = chunk.readShorts();
                payload = ChunkReader.rep("   ", level + 1) + "#indices: " + numIndices + ": " + Arrays.toString(indices).substring(0, 400);
                break;
            }
            default: {
                id = "unknown [" + id + "]";
                payload = ChunkReader.rep("   ", level + 1) + "unknown";
            }
        }
        System.out.println(ChunkReader.rep("   ", level) + id + " {");
        if (payload != null) {
            System.out.println(payload);
        }
        for (Chunk child : chunk.getChildren()) {
            ChunkReader.printChunks(child, level + 1);
        }
        System.out.println(ChunkReader.rep("   ", level) + "}");
    }

    private static String rep(String c, int n) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            buf.append(c);
        }
        return buf.toString();
    }

    public static class Chunk {
        int id;
        Chunk parent;
        Array<Chunk> children = new Array();
        ByteArrayInputStream payload;
        byte[] payloadBytes;
        int offset = 0;
        CountingDataInputStream in;

        protected Chunk(int id, Chunk parent, byte[] bytes, int offset, int size) throws IOException {
            this.id = id;
            this.parent = parent;
            this.payload = new ByteArrayInputStream(bytes, offset, size);
            this.payloadBytes = bytes;
            this.offset = offset;
            this.in = new CountingDataInputStream(this.payload);
        }

        public int getId() {
            return this.id;
        }

        public Chunk getParent() {
            return this.parent;
        }

        public Array<Chunk> getChildren() {
            return this.children;
        }

        public int readByte() {
            try {
                return this.in.readByte();
            }
            catch (IOException e) {
                throw new GdxRuntimeException("Couldn't read payload, " + e.getMessage(), e);
            }
        }

        public short readShort() {
            try {
                return this.in.readShort();
            }
            catch (IOException e) {
                throw new GdxRuntimeException("Couldn't read payload, " + e.getMessage(), e);
            }
        }

        public int readInt() {
            try {
                return this.in.readInt();
            }
            catch (IOException e) {
                throw new GdxRuntimeException("Couldn't read payload, " + e.getMessage(), e);
            }
        }

        public long readLong() {
            try {
                return this.in.readLong();
            }
            catch (IOException e) {
                throw new GdxRuntimeException("Couldn't read payload, " + e.getMessage(), e);
            }
        }

        public float readFloat() {
            try {
                return this.in.readFloat();
            }
            catch (IOException e) {
                throw new GdxRuntimeException("Couldn't read payload, " + e.getMessage(), e);
            }
        }

        public double readDouble() {
            try {
                return this.in.readDouble();
            }
            catch (IOException e) {
                throw new GdxRuntimeException("Couldn't read payload, " + e.getMessage(), e);
            }
        }

        public byte[] readBytes() {
            try {
                int len = this.in.readInt();
                byte[] v = new byte[len];
                for (int i = 0; i < len; ++i) {
                    v[i] = this.in.readByte();
                }
                return v;
            }
            catch (IOException e) {
                throw new GdxRuntimeException("Couldn't read payload, " + e.getMessage(), e);
            }
        }

        public short[] readShorts() {
            try {
                int len = this.in.readInt();
                short[] v = new short[len];
                for (int i = 0; i < len; ++i) {
                    v[i] = this.in.readShort();
                }
                return v;
            }
            catch (IOException e) {
                throw new GdxRuntimeException("Couldn't read payload, " + e.getMessage(), e);
            }
        }

        public int[] readInts() {
            try {
                int len = this.in.readInt();
                int[] v = new int[len];
                for (int i = 0; i < len; ++i) {
                    v[i] = this.in.readInt();
                }
                return v;
            }
            catch (IOException e) {
                throw new GdxRuntimeException("Couldn't read payload, " + e.getMessage(), e);
            }
        }

        public long[] readLongs() {
            try {
                int len = this.in.readInt();
                long[] v = new long[len];
                for (int i = 0; i < len; ++i) {
                    v[i] = this.in.readLong();
                }
                return v;
            }
            catch (IOException e) {
                throw new GdxRuntimeException("Couldn't read payload, " + e.getMessage(), e);
            }
        }

        public float[] readFloats() {
            try {
                int len = this.in.readInt();
                float[] v = new float[len];
                for (int i = 0; i < len; ++i) {
                    v[i] = this.in.readFloat();
                }
                return v;
            }
            catch (IOException e) {
                throw new GdxRuntimeException("Couldn't read payload, " + e.getMessage(), e);
            }
        }

        public double[] readDoubles() {
            try {
                int len = this.in.readInt();
                double[] v = new double[len];
                for (int i = 0; i < len; ++i) {
                    v[i] = this.in.readDouble();
                }
                return v;
            }
            catch (IOException e) {
                throw new GdxRuntimeException("Couldn't read payload, " + e.getMessage(), e);
            }
        }

        public String readString() {
            try {
                int len = this.in.readInt();
                byte[] bytes = new byte[len];
                this.in.readFully(bytes);
                return new String(bytes, "UTF-8");
            }
            catch (IOException e) {
                throw new GdxRuntimeException("Couldn't read payload, " + e.getMessage(), e);
            }
        }

        public Chunk getChild(int id) {
            for (int i = 0; i < this.children.size; ++i) {
                Chunk child = this.children.get(i);
                if (child.getId() != id) continue;
                return child;
            }
            return null;
        }

        public Chunk[] getChildren(int id) {
            Array<Chunk> meshes = new Array<Chunk>(true, 16, Chunk.class);
            for (int i = 0; i < this.children.size; ++i) {
                Chunk child = this.children.get(i);
                if (child.getId() != id) continue;
                meshes.add(child);
            }
            meshes.shrink();
            return (Chunk[])meshes.items;
        }
    }
}

