#version 330

in vec3 vNormal;
in vec3 vEye;
in vec4 vVertexPos;

out vec4 out_Color;

uniform samplerCube uSkyboxSampler;

void main()
{
	float depth = ( ( 1.0 + ( vVertexPos.xyz / vVertexPos.w ) ) / 2.0 ).z;
	//Reflection
	vec3 eyePos = normalize( vEye );
	vec3 reflectionVector = reflect( eyePos, normalize( vNormal ) );
	vec4 reflectionColor = texture( uSkyboxSampler, eyePos );
	
	out_Color = reflectionColor;//mix( reflectionColor, vec4( 1.0 ), depth - 0.3 );
}