#version 330
 
layout(points) in;
layout(triangle_strip, max_vertices = 4) out;

in float vParticleSize[];
in float vParticleBrightness[];
out vec2 vTexCoord;
out float fParticleBrightness;

void main() 
{
  gl_Position = ( gl_in[0].gl_Position + vec4( -0.5 * vParticleSize[0], -0.5 * vParticleSize[0], 0.0, 0.0 ) );
  vTexCoord = vec2( 0.0, 0.0 );
  fParticleBrightness = vParticleBrightness[0];
  EmitVertex();
  gl_Position = ( gl_in[0].gl_Position + vec4( 0.5 * vParticleSize[0], -0.5 * vParticleSize[0], 0.0, 0.0 ) );
  vTexCoord = vec2( 1.0, 0.0 );
  fParticleBrightness = vParticleBrightness[0];
  EmitVertex();
  gl_Position = ( gl_in[0].gl_Position + vec4( -0.5 * vParticleSize[0], 0.5 * vParticleSize[0], 0.0, 0.0 ) );
  vTexCoord = vec2( 0.0, 1.0 );
  fParticleBrightness = vParticleBrightness[0];
  EmitVertex();
  gl_Position = ( gl_in[0].gl_Position + vec4( 0.5 * vParticleSize[0], 0.5 * vParticleSize[0], 0.0, 0.0 ) );
  vTexCoord = vec2( 1.0, 1.0 );
  fParticleBrightness = vParticleBrightness[0];
  EmitVertex();
  EndPrimitive();
}