#version 330

layout( location = 0 ) in vec3 InVertex;
layout( location = 1 ) in float InParticleSize;
layout( location = 2 ) in float InParticleBrightness;

out float vParticleSize;
out float vParticleBrightness;

uniform mat4 uModelMatrix;
uniform mat4 uViewMatrix;
uniform mat4 uProjectionMatrix;

void main()
{
	vParticleSize = InParticleSize;
	vParticleBrightness = InParticleBrightness;
	vec3 pos = InVertex;
	gl_Position = uProjectionMatrix * uViewMatrix * uModelMatrix * vec4( pos, 1.0 );
}