uniform sampler2D u_texture;
uniform float u_progress;
uniform float u_fluxbar;

void main()
{
	vec2 uv = gl_TexCoord[0].xy;
	vec4 frag = texture2D(u_texture, uv);
	
	float xlen = length(vec2(uv.x, 0.0) - vec2(0.5, 0.0));
	float ylen = length(vec2(uv.y, 0.0) - vec2(0.5, 0.0));
	ylen = (0.5-ylen) + 1.5;
	
	float threshold = u_progress * u_progress * 0.35;
	
	float ss = smoothstep(u_progress-threshold, u_progress * ylen, xlen);
	
	frag.rgb = frag.rgb * (1.0 - ss * 0.7);
	//mix(0.25, 1.0, uv.x <= u_progress ? 1.0 : 0.0);
	
	frag.rgb = frag.rgb * (u_fluxbar > 0.0 ? (u_progress * 0.5 + 0.5) * 2.0 : 1.0);
	
	gl_FragColor = frag;
}