/*
 * Decompiled with CFR 0.152.
 */
package com.assypeli.rakennukset;

import com.assypeli.domain.Pelaaja;
import com.assypeli.domain.Rakennus;
import com.assypeli.domain.Rakennustiedot;
import com.assypeli.domain.Varasto;

public class Magiavarasto
extends Rakennus
implements Varasto {
    private int kapasiteetti;
    private float maara;

    public Magiavarasto(Pelaaja pelaaja, int maara) {
        super(Rakennustiedot.MAGIAVARASTO, pelaaja);
        super.setRakennus(this);
        this.maara = maara;
        this.kapasiteetti = this.laskeKapasiteetti(this.getTaso());
    }

    @Override
    public void lisaa(float maara) {
        this.maara = this.maara + maara <= (float)this.kapasiteetti ? (this.maara += maara) : (float)this.kapasiteetti;
    }

    @Override
    public void vahenna(float maara) {
        if (this.maara - maara >= 0.0f) {
            this.maara -= maara;
        }
    }

    @Override
    public boolean riittaako(int maara) {
        return this.maara >= (float)maara;
    }

    @Override
    public int getMaara() {
        return (int)this.maara;
    }

    @Override
    public int getKapasiteetti() {
        return this.kapasiteetti;
    }

    @Override
    public boolean voiRakentaa() {
        return true;
    }

    @Override
    public void tarkistaOminaisuudet() {
        this.kapasiteetti = this.laskeKapasiteetti(super.getTaso());
    }

    public int laskeKapasiteetti(int taso) {
        switch (taso) {
            case 0: {
                return 20;
            }
            case 1: {
                return 30;
            }
            case 2: {
                return 40;
            }
            case 3: {
                return 50;
            }
            case 4: {
                return 60;
            }
        }
        return 0;
    }
}

