
float4x4 g_mWorldViewProjection;    

float g_windowWidth;
float g_windowHeight;

float4 g_blur_strength;

struct VS_INPUT {
    float4 vPosition : POSITION;
    float2 vTexcoord : TEXCOORD;
};

struct VS_OUTPUT {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vPosSS : TEXCOORD1;
};


VS_OUTPUT vs( const VS_INPUT v ) {
  VS_OUTPUT o;
  
  o.vPosition = mul(v.vPosition, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
  
  o.vTexcoord = (v.vTexcoord); 
  
  return o;
}


struct PS_OUT {
  float4 rt0 : COLOR0; // final mixed image
};


float4 g_color = float4(1.0, 1.0, 1.0, 1.0);

float4 g_grid;


texture g_tDiffuse;

sampler smDiffuse =
sampler_state {
  Texture = <g_tDiffuse>;
  MipFilter = POINT;
  MinFilter = LINEAR; // POINT
  MagFilter = LINEAR; // LINEAR  
  AddressU = BORDER;
  AddressV = BORDER;
};


texture g_tTonemap;

sampler smTonemap =
sampler_state {
  Texture = <g_tTonemap>;
  MipFilter = POINT;
  MinFilter = POINT; // POINT
  MagFilter = POINT; // LINEAR  
  AddressU = BORDER;
  AddressV = BORDER;
};

PS_OUT ps( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float2 tcOfs = float2(0.5/g_windowWidth, 0.5/g_windowHeight);
  
  float4 colorIn = tex2D(smDiffuse, In.vTexcoord+tcOfs);

  float4 result = 0;
  
  float k = 0.0;
  
  tcOfs = float2(-0.5/1920.0, 0.0/12.0);
  k = clamp(colorIn.r, 0.0, 10.0);
  result.r = tex2D(smTonemap, float2(k*0.99, 0.0)+tcOfs)*1.0;
  k = clamp(colorIn.g, 0.0, 10.0);
  result.g = tex2D(smTonemap, float2(k*0.99, 0.0)+tcOfs)*1.0;
  k = clamp(colorIn.b, 0.0, 10.0);
  result.b = tex2D(smTonemap, float2(k*0.99, 0.0)+tcOfs)*1.0;
 
  result *= 1.0;

  result.a = colorIn.a;
  
  o.rt0 = result;
  return o;
}



technique Render {
    pass P0 {          
        VertexShader = compile vs_3_0 vs( );
        PixelShader  = compile ps_3_0 ps( );
    }
}

