

texture g_DispTexture;
sampler DisplaceSampler = sampler_state
{
texture = <g_DispTexture>;
MinFilter = POINT;
MagFilter = POINT;
MipFilter = NONE;
AddressU = CLAMP;
AddressV = CLAMP;
};


struct VS_INPUT_INSTANCED {
    float4 vPosition : POSITION;
    float3 vNormal : NORMAL;
    float2 vTexcoord : TEXCOORD0;
    float4 vWHI : TEXCOORD1;
    float3 vTangent : TANGENT;
    float3 vBiNormal : BINORMAL;
};

float4 g_mesh_whi;
float4 g_meshSize;

VS_OUTPUT_BASIC_KO vs_deferred_draw_march_instanced( const VS_INPUT_INSTANCED v ) {
  VS_OUTPUT_BASIC_KO o;
  
  float4 vPosTrans = v.vPosition*(float4(1.0, 1.0, 1.0, 0.0)*8.0+float4(0.0, 0.0, 0.0, 1.0));
   
  float4 mSS = mul(vPosTrans, g_mWorldViewProjection);
  float2 tcs = g_texCoordScale;
  float4 pulkka = (tex2Dlod(DisplaceSampler, float4(v.vWHI.x+0.5/g_windowWidth, v.vWHI.y+0.5/g_windowHeight, 0, 0)));
  pulkka.w = 0.0;

 // vPosTrans = rotateXZ(vPosTrans, 5.0*clamp(sin(vPosTrans.y*0.150+g_time*0.4),0.0,1.0));
  
  pulkka.x /= g_meshSize.x;
  pulkka.y /= g_meshSize.y;
  pulkka.z /= g_meshSize.z;
  vPosTrans += pulkka;
  
  o.vPosition = mul(vPosTrans, g_mWorldViewProjection);
  
  o.vPosSS = o.vPosition;
  
  float4 possex = mul(vPosTrans, g_mWorld);
  o.vPosSO = mul(possex, g_mView);
  
  float3 normalResult;
  normalResult = mul(v.vNormal, (float3x3)(g_mWorld));
  o.vNormal = float4((normalize(mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);

  normalResult = mul(v.vTangent, (float3x3)(g_mWorld));
  o.vTangent = float4((normalize(mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);

  normalResult = mul(v.vBiNormal, (float3x3)(g_mWorld));
  o.vBiNormal = float4((normalize(mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);
  
  float2 localTexCoordOfs;
  
  o.vTexcoord = v.vTexcoord*g_texCoordScale.xy*g_diffuseTexCoordScale.xy+g_texCoordOfs.xy+g_diffuseTexCoordOfs.xy;
  o.vTexcoordHS.xy = v.vTexcoord*g_texCoordScale.xy*g_heightTexCoordScale.xy+g_texCoordOfs.xy+g_heightTexCoordOfs.xy;
  o.vTexcoordHS.zw = v.vTexcoord*g_texCoordScale.xy*g_specularTexCoordScale.xy+g_texCoordOfs.xy+g_specularTexCoordOfs.xy;
    
  return o;
}



technique march_instanced {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_deferred_draw_march_instanced( );
        PixelShader  = compile ps_3_0 ps_deferred_draw_march( );
    }
}
