

float2 height_func_depth(float2 p) {
   float2 resx = float2(1.0/1024.0, 0.0);
   float2 resy = float2(0.0, 1.0/1024.0);
   float2 result = 0;
   result.x = tex2D(smHeight, p+resx).g-tex2D(smHeight, p-resx).g;
   result.y = tex2D(smHeight, p+resy).g-tex2D(smHeight, p-resy).g;
   return result;
}

MRT_OUT ps_deferred_draw_parallax( VS_OUTPUT_BASIC In ) {
  MRT_OUT o=(MRT_OUT)0;
  
  
 

    
  float4 ray = In.vPosSS;
  
 // ray.z = ray.z / ray.w;
  
  float4 rayTan;
  
  rayTan.x = dot(In.vTangent, ray);
  rayTan.y = dot(In.vBiNormal, ray);
  rayTan.z = dot(In.vNormal, ray);
  rayTan.w = 0.0;
  
  rayTan = normalize(rayTan);
  
  float height = tex2D(smHeight, In.vTexcoord).g;
  
 
  float2 tc = In.vTexcoord+rayTan.xy*(0.04*height-0.02)*g_heightIntensity;
 
  float4 ort2 = tex2D(smDiffuse, tc)*g_materialDiffuse;
  ort2.xyz *= g_diffuseIntensity;
  o.rt2 = ort2;
  
  if (o.rt2.a < 0.005)
    discard;  
  
//  o.rt2.xyz = ray.xyz;
    
  float4 bumpe = 0;
  bumpe.xy = height_func_depth(tc);
  bumpe = bumpe*g_heightIntensity;
  bumpe.z = 1.0;
  bumpe = normalize(bumpe);
       
  o.rt0 = (In.vPosSS.z+0.04*height*g_heightIntensity) / In.vPosSS.w;
  o.rt1 = (normalize(In.vNormal*bumpe.z+In.vTangent*bumpe.x+In.vBiNormal*bumpe.y)+1.0)*0.5;
  o.rt1.w = 1.0;
  
  o.rt3.x = g_materialAmbient; // pure ambient
  o.rt3.y = tex2D(smSpecular, tc).g*g_specularIntensity;
  o.rt3.z = g_specularExponent;  
  
  return o;
}


technique parallax {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_deferred_draw( );
        PixelShader  = compile ps_3_0 ps_deferred_draw_parallax( );
    }
}

struct VS_OUTPUT_BASIC_CITY {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vNormal : TEXCOORD1;
    float4  vPosSS : TEXCOORD2;
    float4  vTangent : TEXCOORD3;
    float4  vBiNormal : TEXCOORD4;
    float4  vTexcoordHS : TEXCOORD5;
    float4  vNormalOrig : TEXCOORD6;
};


VS_OUTPUT_BASIC_CITY vs_deferred_draw_city( const VS_INPUT v ) {
  VS_OUTPUT_BASIC_CITY o;
  
  float4 vPosTrans = v.vPosition;
  
  o.vPosition = mul(vPosTrans, g_mWorldViewProjection);
  
  o.vPosSS = o.vPosition;
  
  float3 normalResult;
  normalResult = mul(v.vNormal, (float3x3)(g_mWorld));
  o.vNormal = float4((normalize(mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);

  normalResult = mul(v.vTangent, (float3x3)(g_mWorld));
  o.vTangent = float4((normalize(mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);

  normalResult = mul(v.vBiNormal, (float3x3)(g_mWorld));
  o.vBiNormal = float4((normalize(mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);
  
  float2 localTexCoordOfs;
  
  o.vTexcoord = v.vTexcoord*g_texCoordScale.xy*g_diffuseTexCoordScale.xy+g_texCoordOfs.xy+g_diffuseTexCoordOfs.xy;
  o.vTexcoordHS.xy = v.vTexcoord*g_texCoordScale.xy*g_heightTexCoordScale.xy+g_texCoordOfs.xy+g_heightTexCoordOfs.xy;
  o.vTexcoordHS.zw = v.vTexcoord*g_texCoordScale.xy*g_specularTexCoordScale.xy+g_texCoordOfs.xy+g_specularTexCoordOfs.xy;

  o.vNormalOrig = float4(v.vNormal, 0.0);
    
  return o;
}

MRT_OUT ps_deferred_draw_city( VS_OUTPUT_BASIC_CITY In ) {
  MRT_OUT o=(MRT_OUT)0;
  
       
  float4 ray = In.vPosSS;
  
 // ray.z = ray.z / ray.w;
  
  float4 rayTan;
  
  rayTan.x = dot(In.vTangent, ray);
  rayTan.y = dot(In.vBiNormal, ray);
  rayTan.z = dot(In.vNormal, ray);
  rayTan.w = 0.0;
  
  rayTan = normalize(rayTan);
  
  float height = tex2D(smHeight, In.vTexcoord).g;
  
 
  float2 tc = In.vTexcoord+rayTan.xy*(0.04*height-0.02)*g_heightIntensity;
 
  float4 ort2 = tex2D(smDiffuse, tc)*g_materialDiffuse;
  ort2.xyz *= g_diffuseIntensity;
  o.rt2 = ort2;
  
  if (o.rt2.a < 0.005)
    discard;  

 
  float tcMuls = 1.0; // saturate(abs(In.vNormalOrig.y)*2.0);
  
//  o.rt2.xyz = ray.xyz;
    
  float4 bumpe = 0;
  bumpe.xy = height_func_depth(tc);
  bumpe = bumpe*g_heightIntensity;
  bumpe.z = 1.0;
  bumpe = normalize(bumpe);
       
  o.rt0 = (In.vPosSS.z+0.04*height*g_heightIntensity) / In.vPosSS.w;
  o.rt1 = (normalize(In.vNormal*bumpe.z+In.vTangent*bumpe.x+In.vBiNormal*bumpe.y)+1.0)*0.5;
  o.rt1.w = 1.0;

  o.rt2 *= tcMuls;
  
  o.rt3.x = g_materialAmbient; // pure ambient
  o.rt3.y = tex2D(smSpecular, tc).g*g_specularIntensity*tcMuls;
  o.rt3.z = g_specularExponent;  
  
  return o;
}


technique city {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_deferred_draw_city( );
        PixelShader  = compile ps_3_0 ps_deferred_draw_city( );
    }
}



MRT_OUT ps_deferred_draw_water( VS_OUTPUT_BASIC In ) {
  MRT_OUT o=(MRT_OUT)0;
  
  
     
  float4 ray = In.vPosSS;
  
 // ray.z = ray.z / ray.w;
  
  float4 rayTan;
  
  rayTan.x = dot(In.vTangent, ray);
  rayTan.y = dot(In.vBiNormal, ray);
  rayTan.z = dot(In.vNormal, ray);
  rayTan.w = 0.0;
  
  rayTan = normalize(rayTan);

  float speed = 0.15;
  
  float height = tex2D(smHeight, In.vTexcoord+float2(0.123,0.342*0)*g_time*speed).g*tex2D(smHeight, In.vTexcoord*2.567+float2(0.23,0.1342*0)*g_time*speed).g;
  
 
  float2 tc = In.vTexcoord+rayTan.xy*(0.04*height-0.02)*g_heightIntensity;
 
  float4 ort2 = tex2D(smDiffuse, tc+float2(0.123,0.342*0)*g_time*speed)*tex2D(smDiffuse, tc*2.567+float2(0.23,0.1342*0)*g_time*speed)*g_materialDiffuse;
  ort2.xyz *= g_diffuseIntensity;
  o.rt2 = ort2;
  
  if (o.rt2.a < 0.005)
    discard;  
  
//  o.rt2.xyz = ray.xyz;
    
  float4 bumpe = 0;
  bumpe.xy = height_func_depth(tc);
  bumpe = bumpe*g_heightIntensity;
  bumpe.z = 1.0;
  bumpe = normalize(bumpe);
       
  o.rt0 = (In.vPosSS.z+0.04*height*g_heightIntensity) / In.vPosSS.w;
  o.rt1 = (normalize(In.vNormal*bumpe.z+In.vTangent*bumpe.x+In.vBiNormal*bumpe.y)+1.0)*0.5;
  o.rt1.w = 1.0;
  
  o.rt3.x = g_materialAmbient; // pure ambient
  o.rt3.y = tex2D(smSpecular, tc).g*g_specularIntensity;
  o.rt3.z = g_specularExponent;  
  
  return o;
}


technique water {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_deferred_draw( );
        PixelShader  = compile ps_3_0 ps_deferred_draw_water( );
    }
}



MRT_OUT ps_deferred_draw_water2d( VS_OUTPUT_BASIC In ) {
  MRT_OUT o=(MRT_OUT)0;
  
  
     
  float4 ray = In.vPosSS;
  
 // ray.z = ray.z / ray.w;
  
  float4 rayTan;
  
  rayTan.x = dot(In.vTangent, ray);
  rayTan.y = dot(In.vBiNormal, ray);
  rayTan.z = dot(In.vNormal, ray);
  rayTan.w = 0.0;
  
  rayTan = normalize(rayTan);

  float speed = 0.15;
  
  float height = tex2D(smHeight, In.vTexcoord+float2(0.123,0.342)*g_time*speed).g*tex2D(smHeight, In.vTexcoord*2.567+float2(0.23,0.1342)*g_time*speed).g;
  
 
  float2 tc = In.vTexcoord+rayTan.xy*(0.04*height-0.02)*g_heightIntensity;
 
  float4 ort2 = tex2D(smDiffuse, tc+float2(0.123,0.342)*g_time*speed)*tex2D(smDiffuse, tc*2.567+float2(0.23,0.1342)*g_time*speed)*g_materialDiffuse;
  ort2.xyz *= g_diffuseIntensity;
  o.rt2 = ort2;
  
  if (o.rt2.a < 0.005)
    discard;  
  
//  o.rt2.xyz = ray.xyz;
    
  float4 bumpe = 0;
  bumpe.xy = height_func_depth(tc);
  bumpe = bumpe*g_heightIntensity;
  bumpe.z = 1.0;
  bumpe = normalize(bumpe);
       
  o.rt0 = (In.vPosSS.z+0.04*height*g_heightIntensity) / In.vPosSS.w;
  o.rt1 = (normalize(In.vNormal*bumpe.z+In.vTangent*bumpe.x+In.vBiNormal*bumpe.y)+1.0)*0.5;
  o.rt1.w = 1.0;
  
  o.rt3.x = g_materialAmbient; // pure ambient
  o.rt3.y = tex2D(smSpecular, tc+float2(0.123,0.342)*g_time*speed).g*tex2D(smSpecular, tc*2.567+float2(0.23,0.1342)*g_time*speed).g*g_specularIntensity;
  o.rt3.z = g_specularExponent;  
  
  return o;
}


technique water2d {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_deferred_draw( );
        PixelShader  = compile ps_3_0 ps_deferred_draw_water2d( );
    }
}
