

texture g_tNormal;
sampler smNormal = sampler_state
{
texture = <g_tNormal>;
MinFilter = POINT;
MagFilter = POINT;
MipFilter = NONE;
AddressU = CLAMP;
AddressV = CLAMP;
};


float2 height_func_bump(float2 p) {
   float2 resx = float2(1.0/512.0, 0.0);
   float2 resy = float2(0.0, 1.0/512.0);
   float2 result = 0;
   result.x = tex2D(smHeight, p+resx).g-tex2D(smHeight, p-resx).g;
   result.y = tex2D(smHeight, p+resy).g-tex2D(smHeight, p-resy).g;
 //  result.xy = tex2D(smHeight, p+resx).rg;
 //  result.y = tex2D(smHeight, p+resy).g-tex2D(smHeight, p-resy).g;
   
   return result;
}

float fkb(float3 vv) {
  float box = 0.990-((tex2D(smHeight,vv.xy).g))*0.005-vv.z;
  return box;
}

float g_normalDistort = 1.0;

VS_OUTPUT_BASIC vs_deferred_draw_nd( const VS_INPUT v ) {
  VS_OUTPUT_BASIC o;

  float4 vPosTrans = v.vPosition;

  vPosTrans += float4(v.vNormal*g_normalDistort, 0.0);
  o.vPosition = mul(vPosTrans, g_mWorldViewProjection);
  
  o.vPosSS = o.vPosition;
  
  float3 normalResult;
  normalResult = mul(v.vNormal, (float3x3)(g_mWorld));
  normalResult = normalize(normalResult);
  o.vNormal = float4(((mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);

  normalResult = mul(v.vTangent, (float3x3)(g_mWorld));
  normalResult = normalize(normalResult);
  o.vTangent = float4(((mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);

  normalResult = mul(v.vBiNormal, (float3x3)(g_mWorld));
  normalResult = normalize(normalResult);
  o.vBiNormal = float4(((mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);
  
  float2 localTexCoordOfs;
  
  o.vTexcoord = v.vTexcoord*g_texCoordScale.xy*g_diffuseTexCoordScale.xy+g_texCoordOfs.xy+g_diffuseTexCoordOfs.xy;
  o.vTexcoordHS.xy = v.vTexcoord*g_texCoordScale.xy*g_heightTexCoordScale.xy+g_texCoordOfs.xy+g_heightTexCoordOfs.xy;
  o.vTexcoordHS.zw = v.vTexcoord*g_texCoordScale.xy*g_specularTexCoordScale.xy+g_texCoordOfs.xy+g_specularTexCoordOfs.xy;
    
  return o;
}

float4 g_spikesDensity;
float g_spikeThreshold;

VS_OUTPUT_BASIC vs_deferred_draw_nd_spikes( const VS_INPUT v ) {
  VS_OUTPUT_BASIC o;

  float4 vPosTrans = v.vPosition;
  
  float spikeArea = sin(vPosTrans.x*g_spikesDensity.x)+cos(vPosTrans.y*g_spikesDensity.y)+sin(cos(vPosTrans.z*g_spikesDensity.z));
  spikeArea = smoothstep(0.0, 3.0, spikeArea-g_spikeThreshold)/3.0*g_normalDistort;

  vPosTrans += float4(v.vNormal*(0.0+spikeArea), 0.0);
  o.vPosition = mul(vPosTrans, g_mWorldViewProjection);
  
  o.vPosSS = o.vPosition;
  
  float3 normalResult;
  normalResult = mul(v.vNormal, (float3x3)(g_mWorld));
  normalResult = normalize(normalResult);
  o.vNormal = float4(((mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);

  normalResult = mul(v.vTangent, (float3x3)(g_mWorld));
  normalResult = normalize(normalResult);
  o.vTangent = float4(((mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);

  normalResult = mul(v.vBiNormal, (float3x3)(g_mWorld));
  normalResult = normalize(normalResult);
  o.vBiNormal = float4(((mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);
  
  float2 localTexCoordOfs;
  
  o.vTexcoord = v.vTexcoord*g_texCoordScale.xy*g_diffuseTexCoordScale.xy+g_texCoordOfs.xy+g_diffuseTexCoordOfs.xy;
  o.vTexcoordHS.xy = v.vTexcoord*g_texCoordScale.xy*g_heightTexCoordScale.xy+g_texCoordOfs.xy+g_heightTexCoordOfs.xy;
  o.vTexcoordHS.zw = v.vTexcoord*g_texCoordScale.xy*g_specularTexCoordScale.xy+g_texCoordOfs.xy+g_specularTexCoordOfs.xy;
    
  return o;
}


float3 rotAroundAxis(float3 vec, float3 axis, float alpha) {
  float ca = cos(alpha);
  float sa = sin(alpha);
  float u = axis.x;
  float v = axis.y;
  float w = axis.z;
  float3 rot;
  rot.x = u*(u*vec.x+v*vec.y+w*vec.z)*(1.0-ca)+vec.x*ca+(-w*vec.y+v*vec.z)*sa;
  rot.y = v*(u*vec.x+v*vec.y+w*vec.z)*(1.0-ca)+vec.y*ca+(w*vec.x-u*vec.z)*sa;
  rot.z = w*(u*vec.x+v*vec.y+w*vec.z)*(1.0-ca)+vec.z*ca+(-v*vec.x+u*vec.y)*sa;
  return rot;
}

float3 cross(float3 a, float3 b) {
  float3 r;
  r.x = a.y*b.z - a.z*b.y;
  r.y = a.z*b.x - a.x*b.z;
  r.z = a.x*b.y - a.y*b.x;
  return r;
}

float3 getNormal3(float2 n) {
  float3 n3;
  n3.xy = n*2.0-1.0;
  n3.z = sqrt(1.0-n3.x*n3.x-n3.y*n3.y);
  return n3;
}

float3 rotateXZ(float3 p, float a) {
  float3 r = p;
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  return r;
}

float AtanSafe(float y, float x) {
 float ret=0.0;
	if (x!=0.0) {
		if (x>0.0) {
			ret=atan(y/x);
		} else	{
			ret=atan(y/x)+3.141592;
		}
	} else {
		if (y>=0.0) {
			ret=0.5*3.141592;
		} else {
			ret=-0.5*3.141592;
		}
	}
 return ret;
}

float4 g_tcScaleSS;

VS_OUTPUT_BASIC vs_deferred_draw_tc_instanced( const VS_INPUT v ) {
  VS_OUTPUT_BASIC o;
// 
  float4 vPosTrans = v.vPosition*(float4(g_meshSize.x, g_meshSize.y, g_meshSize.z, 0.0)*1.0+float4(0.0, 0.0, 0.0, 1.0));

  float2 tcs = g_texCoordScale;
  float4 tcSS = float4(v.vWHI.x+0.5/g_windowWidth, v.vWHI.y+0.5/g_windowHeight, 0, 0);
  
  float3 normalResult;
  
  float3 normalSS = getNormal3(tex2Dlod(smNormal, tcSS).xy);
  float3 normalOrigSS = normalSS;
  normalSS = mul(normalSS, (float3x3)(g_mInvView));
  normalSS.x = -normalSS.x;
  normalSS.y = -normalSS.y;
  float4 pulkka = (tex2Dlod(DisplaceSampler, tcSS));
  
  float3 zVec = float3(0.0, 0.0, 1.0);
  float dotsi = dot(normalSS, zVec);
 // if (abs(dotsi)>0.05) {
	  float3 rotAxis = cross(normalSS, zVec);
	  rotAxis = normalize(rotAxis);
	  float angle = acos(dotsi);
	  //float length = sqrt(dot(vPosTrans.xyz, vPosTrans.xyz));
	  //vPosTrans.xyz/=length;
	  vPosTrans.xyz = rotAroundAxis(vPosTrans.xyz, rotAxis, angle); //*length;
 // }
  
  /*
  float angle = AtanSafe(normalSS.x, normalSS.z);
  vPosTrans.xyz = rotateXZ(vPosTrans.xyz, -angle*0.5);
  */
  // vPosTrans = 
  //pulkka.x /= g_meshSize.x;
  //pulkka.y /= g_meshSize.y;
  //pulkka.z /= g_meshSize.z;
  pulkka.w = 0.0;
  vPosTrans.xyz -= normalOrigSS.xyz*1.0;
  vPosTrans += pulkka;
  
  float4 tt;
 // tt = mul(vPosTrans, g_mWorld);
 // tt.xyz *= 1.0/g_meshSize.xyz;
  tt = mul(vPosTrans, g_mView);
  tt = mul(tt, g_mProj);
  o.vPosition = tt;
  o.vPosSS = o.vPosition;
    
  normalResult = mul(v.vNormal, (float3x3)(g_mWorld));
  normalResult = normalize(normalResult);
  o.vNormal = float4(((mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);

  float3 tan = v.vTangent;
  float3 bin = v.vBiNormal;
  float2 tc = v.vTexcoord;
  
  normalResult = mul(tan, (float3x3)(g_mWorld));
  o.vTangent = float4((normalize(mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);
  normalResult = mul(bin, (float3x3)(g_mWorld));
  o.vBiNormal = float4((normalize(mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);
  
  float2 localTexCoordOfs;
        
  o.vTexcoord = tc*g_texCoordScale.xy*g_diffuseTexCoordScale.xy+g_texCoordOfs.xy+g_diffuseTexCoordOfs.xy+tcSS.xy*g_tcScaleSS.xy; //+(ssPos.xy*0.5+1.0);
  o.vTexcoordHS.xy = tc*g_texCoordScale.xy*g_heightTexCoordScale.xy+g_texCoordOfs.xy+g_heightTexCoordOfs.xy+tcSS.xy*g_tcScaleSS.xy; //+(ssPos.xy*0.5+1.0);
  o.vTexcoordHS.zw = tc*g_texCoordScale.xy*g_specularTexCoordScale.xy+g_texCoordOfs.xy+g_specularTexCoordOfs.xy+tcSS.xy*g_tcScaleSS.xy; //+(ssPos.xy*0.5+1.0);  
    
  return o;
}



MRT_OUT ps_deferred_draw_bump( VS_OUTPUT_BASIC In ) {
  MRT_OUT o=(MRT_OUT)0;
  float2 tc = In.vTexcoord;
 
   float4 ort2 = (tex2D(smDiffuse, In.vTexcoord)*0.5+0.5*tex2D(smDiffuse, In.vTexcoord*0.1))*g_materialDiffuse;
//   float4 ort2 = (tex2D(smDiffuse, In.vTexcoord))*g_materialDiffuse;
   ort2.xyz *= g_diffuseIntensity;
   o.rt2 = ort2;
  
  if (o.rt2.a < 0.005) {
    discard;
  }
  
  float specAmount = tex2D(smSpecular, In.vTexcoordHS.zw).g;

  // emit particle amount
  
  //float emitPart = frac(g_emitPart);
  //float godAmount = g_emitPart-frac(g_emitPart);
  //emitPart += godAmount;
  o.rt2.a = g_emitPart;

  float4 bumpe = 0;
  bumpe.xy = height_func_bump(In.vTexcoordHS.xy);
  bumpe = bumpe*g_heightIntensity; //*tex2D(smSpectrum, float2(0.001, 0.0));
  bumpe.z = -1.0;
  bumpe = normalize(bumpe);

  float depthOfs = 0.0f;  
	
 // o.rt0 = In.vPosSS.z/In.vPosSS.w;
  float dee2 = (In.vPosSS.z)/In.vPosSS.w+0.0;
  o.rt0.r = getPointZ(getPointDist(dee2)+depthOfs);
 
  o.rt1 = (normalize(In.vNormal*bumpe.z+In.vTangent*bumpe.x*In.vBiNormal*bumpe.y)+1.0)*0.5;
  
  //
  o.rt1.zw = In.vTexcoordHS.xy*g_uv;
  
  o.rt3.x = g_materialAmbient; // pure ambient
  o.rt3.y = specAmount*g_specularIntensity;
  o.rt3.z = g_specularExponent;
  o.rt3.w = g_refl+g_glassiness*100.0;  
  
  return o;
  
  // o.rt3.z = 0.0;  
  
}


MRT_OUT ps_deferred_draw_bump_refl( VS_OUTPUT_BASIC In ) {
  MRT_OUT o=(MRT_OUT)0;
/*
  float4 rayTan;
  float4 ray = (In.vPosSO/(In.vPosSO.w));
 // ray.z += 1.0;
  rayTan.x = dot((In.vTangent), ray);
  rayTan.y = dot((In.vBiNormal), ray);
  rayTan.z = dot(-(In.vNormal), ray)*1.0;
  rayTan.w = 0.0;
  
  rayTan = normalize(rayTan);
  
  float height = tex2D(smHeight, In.vTexcoord).g;
  
  float2 tc = In.vTexcoord;
  tc.y = tc.y;
  
  float hd = 0.0;
  float steps = 1.0f;
  int onceIn = 0;
  float deptho = 1.0; 
  float dir = 1.0;
  
  float po = max(0.25, rayTan.z);
  float pk = min(0.25, rayTan.z);
  
  for (int i=0; i<steps; i++) {
    float hn = fkb(float3(tc.x, tc.y, hd));
    height = hn;

    tc += rayTan.xy*1.0*0.005*deptho*dir/steps/po;
    hd += deptho/steps*4.0*pk*dir;

    if (hn < 0.0) {
      onceIn = 1;
	}
	if (onceIn) {
	  deptho *= 0.75;
	  if (hn < 0.0) {
	    dir = -1.0;
	  } else {
	    dir = 1.0;
	  }
	}
  }
  
  if (onceIn == 0) {
//    discard;
  }
 
  float4 ort2 = tex2D(smDiffuse, tc)*g_materialDiffuse;
  ort2.xyz *= g_diffuseIntensity;
  o.rt2 = ort2;
  
  if (o.rt2.a < 0.005)
    discard;  
	
  
  float4 bumpe = 0;
  float nomV = fkb(float3(tc.x, tc.y, hd));
  bumpe.x = fkb(float3(tc.x+0.005, tc.y, hd))-nomV;
  bumpe.y = fkb(float3(tc.x, tc.y+0.005, hd))-nomV;
  bumpe.z = fkb(float3(tc.x, tc.y, hd+0.005))-nomV;
  bumpe = bumpe;
  bumpe = normalize(bumpe);
  bumpe.xy *= g_heightIntensity;
  
  float dee = (In.vPosSS.z)/In.vPosSS.w+0.0005;
  float dee2 = (In.vPosSS.z)/In.vPosSS.w;
  
  float depthOfs = clamp((hd-0.9), -0.050, 1000000.0)/(pk*1.0)*0.005*1.0*22.0/g_heightTexCoordScale.x;
 // o.Depth = getPointZ(getPointDist(dee)+depthOfs);
  o.rt0.r = getPointZ(getPointDist(dee2)+depthOfs);//(In.vPosSS.z)/In.vPosSS.w;

  o.rt1 = (normalize(In.vNormal*bumpe.z+In.vTangent*bumpe.x+In.vBiNormal*bumpe.y)+1.0)*0.5;
  o.rt1.zw = float2(tc.x, tc.y)*g_uv;
  
  // emit particle amount
  o.rt2.a = g_emitPart;
  
  o.rt3.x = g_materialAmbient; // pure ambient
  o.rt3.y = tex2D(smSpecular, tc).g*g_specularIntensity;
  o.rt3.z = g_specularExponent;
  o.rt3.w = g_refl+100.0*g_glassiness;  
  
  return o;
  */
 
  float2 tc = In.vTexcoord;
 
   float4 ort2 = (tex2D(smDiffuse, In.vTexcoord)*0.5+0.5*tex2D(smDiffuse, In.vTexcoord*0.1))*g_materialDiffuse;
//   float4 ort2 = (tex2D(smDiffuse, In.vTexcoord))*g_materialDiffuse;
   ort2.xyz *= g_diffuseIntensity;
   o.rt2 = ort2;
  
  if (o.rt2.a < 0.005) {
    discard;
  }

  // emit particle amount
  o.rt2.a = g_emitPart;

  /*  
  float4 bumpe = 0;
  bumpe.xy = height_func_bump(In.vTexcoordHS.xy);
  bumpe = bumpe*g_heightIntensity; //*tex2D(smSpectrum, float2(0.001, 0.0));
  bumpe.z = 1.0;
  bumpe = normalize(bumpe);
  */
  
  float4 bumpe = 0;
  float hd = 0.0;
  float nomV = fkb(float3(tc.x, tc.y, hd));
  bumpe.x = fkb(float3(tc.x+0.005, tc.y, hd))-nomV;
  bumpe.y = fkb(float3(tc.x, tc.y+0.005, hd))-nomV;
  bumpe.z = fkb(float3(tc.x, tc.y, hd+0.005))-nomV;
  bumpe = bumpe;
  bumpe = normalize(bumpe);
  bumpe.xy *= g_heightIntensity;
  
 // bumpe.xyz = float3(0.0, 0.0, -1.0);
  
  /*
  float4 rayTan;
  float4 ray = (In.vPosSO/(In.vPosSO.w));
 // ray.z += 1.0;
  rayTan.x = dot((In.vTangent), ray);
  rayTan.y = dot((In.vBiNormal), ray);
  rayTan.z = dot(-(In.vNormal), ray)*1.0;
  rayTan.w = 0.0;
  rayTan = normalize(rayTan);  
  float pk = min(0.25, rayTan.z);  
  float depthOfs = clamp((0.10-0.9), -0.150, 100000.50)/(pk*1.0)*1.0;
  */
  float depthOfs = 0.0f;  
	
 // o.rt0 = In.vPosSS.z/In.vPosSS.w;
  float dee2 = (In.vPosSS.z)/In.vPosSS.w+0.0;
  o.rt0.r = getPointZ(getPointDist(dee2)+depthOfs);
 
  o.rt1 = (normalize(In.vNormal*bumpe.z+In.vTangent*bumpe.x*In.vBiNormal*bumpe.y)+1.0)*0.5;
  
  //
  o.rt1.zw = In.vTexcoordHS.xy*g_uv;
  
  o.rt3.x = g_materialAmbient; // pure ambient
  o.rt3.y = tex2D(smSpecular, In.vTexcoordHS.zw).g*g_specularIntensity;
  o.rt3.z = g_specularExponent;
  o.rt3.w = g_refl+g_glassiness*100.0;  
  
  return o;
  
 
  // o.rt3.z = 0.0;  
  
}

technique bump_refl {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_deferred_draw( );
        PixelShader  = compile ps_3_0 ps_deferred_draw_bump_refl( );
    }
}

technique bump_refl_instanced {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_deferred_draw_instanced( );
        PixelShader  = compile ps_3_0 ps_deferred_draw_bump_refl( );
    }
}


technique bump {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_deferred_draw( );
        PixelShader  = compile ps_3_0 ps_deferred_draw_bump( );
    }
}


technique bump_tc_instanced {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_deferred_draw_tc_instanced( );
        PixelShader  = compile ps_3_0 ps_deferred_draw_bump( );
    }
}


technique bump_nd {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_deferred_draw_nd( );
        PixelShader  = compile ps_3_0 ps_deferred_draw_bump( );
    }
}


technique bump_nd_spikes {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_deferred_draw_nd_spikes( );
        PixelShader  = compile ps_3_0 ps_deferred_draw_bump( );
    }
}

technique bump_instanced {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_deferred_draw_instanced( );
        PixelShader  = compile ps_3_0 ps_deferred_draw_bump( );
    }
}


texture g_texRefl;
sampler smRefl =
sampler_state {
  Texture = <g_texRefl>;
  MipFilter = LINEAR; // ANISOTROPIC
  MinFilter = LINEAR;
  MagFilter = LINEAR;  
  AddressU = WRAP;
  AddressV = WRAP;
};

float4 g_reflectTcMul;
float g_reflectAmount;
float4 g_reflectTcOfs;

MRT_OUT ps_deferred_draw_reflect( VS_OUTPUT_BASIC In ) {
  MRT_OUT o=(MRT_OUT)0;
 
   float4 ort2 = tex2D(smDiffuse, In.vTexcoord); //*g_materialDiffuse;
   ort2.xyz *= g_diffuseIntensity;
   o.rt2 = ort2;
   
   float2 tkos = (In.vTexcoord-0.5);
   tkos.x *= g_reflectTcMul.x;
   tkos.y *= g_reflectTcMul.y;
   float4 refl = tex2D(smRefl, (tkos+0.5)+g_reflectTcOfs.xy);
   
  
  if (o.rt2.a < 0.005)
    discard;
    
  float4 bumpe = 0;
 
  bumpe.xy = height_func_bump(In.vTexcoordHS.xy);
  bumpe = bumpe*g_heightIntensity;
  bumpe.z = 1.0;
  bumpe = normalize(bumpe);
       
  o.rt0 = In.vPosSS.z / In.vPosSS.w;
  o.rt1 = (normalize(In.vNormal*bumpe.z+In.vTangent*bumpe.x+In.vBiNormal*bumpe.y)+1.0)*0.5;
  o.rt1.w = 1.0;
  
  o.rt2.xyz += refl.xyz*g_reflectAmount;
  
  
  o.rt3.x = g_materialAmbient; // pure ambient
  o.rt3.y = tex2D(smSpecular, In.vTexcoordHS.zw).g*g_specularIntensity;
  o.rt3.z = g_specularExponent;  
  // o.rt3.z = 0.0;  
  
  return o;
}

technique reflect {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_deferred_draw( );
        PixelShader  = compile ps_3_0 ps_deferred_draw_reflect( );
    }
}

