
float4x4 g_mWorldViewProjection;    

float g_luminosity;
float g_whiteness;

float g_windowWidth;
float g_windowHeight;

struct VS_INPUT {
    float4 vPosition : POSITION;
    float2 vTexcoord : TEXCOORD;
};

struct VS_OUTPUT {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vPosSS : TEXCOORD1;
};


VS_OUTPUT vs_aa( const VS_INPUT v ) {
  VS_OUTPUT o;
  
  o.vPosition = mul(v.vPosition, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
  
  float2 correcter = float2((g_windowWidth+0.1)/g_windowWidth, (g_windowHeight+0.1)/g_windowHeight);
  o.vTexcoord = float2(0.5/g_windowWidth, 0.5/g_windowHeight)+(v.vTexcoord); //*correcter; 
//  o.vTexcoord = (1.0-float2(-o.vPosition.x-1.0/g_windowWidth, o.vPosition.y-1.0/g_windowHeight))*0.50*correcter;
  
  return o;
}


struct PS_OUT {
  float4 rt0 : COLOR0; // final mixed image
};

texture g_tDepth;
texture g_tNormal;
texture g_tDiffuse;
texture g_tDiffuseOrig;

sampler smDepth =
sampler_state {
  Texture = <g_tDepth>;
  MipFilter = POINT;
  MinFilter = POINT;
  MagFilter = POINT;
  AddressU = BORDER;
  AddressV = BORDER;
};

sampler smNormal =
sampler_state {
  Texture = <g_tNormal>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;  
  AddressU = BORDER;
  AddressV = BORDER;
};

sampler smDiffuse =
sampler_state {
  Texture = <g_tDiffuse>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;  
  AddressU = CLAMP;
  AddressV = CLAMP;
};


sampler smDiffuseOrig =
sampler_state {
  Texture = <g_tDiffuseOrig>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;  
  AddressU = MIRROR;
  AddressV = MIRROR;
};


float g_glowBaseAngle; // 0.7
float g_glowCurrentDispTexCoordMul; // 0.2
float g_glowAngleTexCoordMul; // 2.0

float4 g_glowCurrentDisp; // 0.0, 2.0, 0.0, 0.0
float4 g_glowSize;

float g_glowMulFactor;


float rand(float2 co){
  return 0.5+(frac(sin(dot(co.xy ,float2(12.9898,78.233))) * 43758.5453))*0.5;
}


PS_OUT ps_blur_cross( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 result = 0;
  
  float2 d = g_glowSize;
  
  float4 current = tex2D(smDiffuseOrig, (In.vTexcoord-float2(0.5, 0.5))*g_glowCurrentDispTexCoordMul+float2(0.5, 0.5));
  
  float angle = dot(current, g_glowCurrentDisp)+g_glowBaseAngle+(In.vTexcoord-float2(0.5, 0.5))*g_glowAngleTexCoordMul;
  
  float2 sc = float2(sin(0.0+angle), cos(0.0+angle));
  float2 scm = float2(sin(-1.57+angle), cos(-1.57+angle));
  
  float2 vx = float2(d.x*sc.y, d.x*sc.x);
  float2 vy = float2(-d.y*sc.x, d.y*sc.y);
  
  result += tex2D(smDiffuse, In.vTexcoord+vy);
  result += tex2D(smDiffuse, In.vTexcoord-vy);
  result += tex2D(smDiffuse, In.vTexcoord+vx);
  result += tex2D(smDiffuse, In.vTexcoord-vx);
  
  vx = float2(d.x*scm.y, d.x*scm.x);
  vy = float2(-d.y*scm.x, d.y*scm.y);
  
  result += tex2D(smDiffuse, In.vTexcoord+vy);
  result += tex2D(smDiffuse, In.vTexcoord-vy);
  result += tex2D(smDiffuse, In.vTexcoord+vx);
  result += tex2D(smDiffuse, In.vTexcoord-vx);
  
  
  result *= 0.125;
  
  o.rt0 = result;
  return o;
}


PS_OUT ps_blur_stream( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 result = 0;
  
  float2 d = g_glowSize;
  
  float4 current = tex2D(smDiffuseOrig, (In.vTexcoord-float2(0.5, 0.5))*g_glowCurrentDispTexCoordMul+float2(0.5, 0.5));
  
  float angleR = current.r*g_glowCurrentDisp.r+g_glowBaseAngle+(In.vTexcoord-float2(0.5, 0.5))*g_glowAngleTexCoordMul;
  float angleG = current.g*g_glowCurrentDisp.g+g_glowBaseAngle+(In.vTexcoord-float2(0.5, 0.5))*g_glowAngleTexCoordMul;
  float angleB = current.b*g_glowCurrentDisp.b+g_glowBaseAngle+(In.vTexcoord-float2(0.5, 0.5))*g_glowAngleTexCoordMul;
  
  float2 scR = float2(sin(0.0+angleR), cos(0.0+angleR));
  float2 scG = float2(sin(0.0+angleG), cos(0.0+angleG));
  float2 scB = float2(sin(0.0+angleB), cos(0.0+angleB));
    
  float2 vx = float2(d.x*scR.y, d.x*scR.x);
  float2 vy = float2(-d.y*scR.x, d.y*scR.y);
  
  result += tex2D(smDiffuse, In.vTexcoord+vy).r;
  result += tex2D(smDiffuse, In.vTexcoord-vy).r;
  result += tex2D(smDiffuse, In.vTexcoord+vx).r;
  result += tex2D(smDiffuse, In.vTexcoord-vx).r;
    
  vx = float2(d.x*scG.y, d.x*scG.x);
  vy = float2(-d.y*scG.x, d.y*scG.y);
  result += tex2D(smDiffuse, In.vTexcoord+vy).g;
  result += tex2D(smDiffuse, In.vTexcoord-vy).g;
  result += tex2D(smDiffuse, In.vTexcoord+vx).g;
  result += tex2D(smDiffuse, In.vTexcoord-vx).g;
  
  vx = float2(d.x*scB.y, d.x*scB.x);
  vy = float2(-d.y*scB.x, d.y*scB.y);
  result += tex2D(smDiffuse, In.vTexcoord+vy).b;
  result += tex2D(smDiffuse, In.vTexcoord-vy).b;
  result += tex2D(smDiffuse, In.vTexcoord+vx).b;
  result += tex2D(smDiffuse, In.vTexcoord-vx).b;
  

  result *= 0.125*g_glowMulFactor;
  
  o.rt0 = result;
  return o;
}


PS_OUT ps_blur_box( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 result = 0;
  
  float2 d = g_glowSize;
  
  float4 current = tex2D(smDiffuseOrig, (In.vTexcoord-float2(0.5, 0.5))*g_glowCurrentDispTexCoordMul+float2(0.5, 0.5));
  
  float angle = dot(current, g_glowCurrentDisp)+g_glowBaseAngle+(In.vTexcoord-float2(0.5, 0.5))*g_glowAngleTexCoordMul;
  
  float2 sc = float2(sin(angle), cos(angle));
  
  float2 vx = float2(d.x*sc.y, d.x*sc.x);
  float2 vy = float2(-d.y*sc.x, d.y*sc.y);

  result += tex2D(smDiffuse, In.vTexcoord+vy*1.0);
  result += tex2D(smDiffuse, In.vTexcoord-vy*1.0);
  result += tex2D(smDiffuse, In.vTexcoord+vx*1.0);
  result += tex2D(smDiffuse, In.vTexcoord-vx*1.0);

  result *= 0.25;
  
  o.rt0 = result;
  return o;
}


float4 unpack(float4 v) {
  return v*2.0-1.0;
}
float4 pack(float4 v) {
 return v*0.5+0.5;
}


PS_OUT ps_blur_norm( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 result = 0;
  
  float2 d = g_glowSize;
  
  float4 current = unpack(tex2D(smDiffuseOrig, (In.vTexcoord-float2(0.5, 0.5))*g_glowCurrentDispTexCoordMul+float2(0.5, 0.5)));
  
  float angle = dot(current, g_glowCurrentDisp)+g_glowBaseAngle+(In.vTexcoord-float2(0.5, 0.5))*g_glowAngleTexCoordMul;
  
  float2 sc = float2(sin(angle), cos(angle));
  
  float2 vx = float2(d.x*sc.y, d.x*sc.x);
  float2 vy = float2(-d.y*sc.x, d.y*sc.y);

  result += unpack(tex2D(smDiffuse, In.vTexcoord+vy*1.0));
  result += unpack(tex2D(smDiffuse, In.vTexcoord-vy*1.0));
  result += unpack(tex2D(smDiffuse, In.vTexcoord+vx*1.0));
  result += unpack(tex2D(smDiffuse, In.vTexcoord-vx*1.0));

  result *= 0.25;
  
  o.rt0 = pack(result);
  return o;
}


bool valueInThr(float v, float thr) {
  if (v<0.0) {
    v = -v;
  }
  if (v<thr) {
    return true;
  }
  return false;
}

float4 tD(float4 d) {
  return d;//(1.0-1.0/(d-1.1));
  
}


const float zFar = 10000.0;
const float zNear = 0.10;


float getPointDist(float z) {
  float clipA = zFar / (zFar - zNear);
  float clipB = zFar*zNear / (zNear - zFar);
  return clipB/(z-clipA);  
}

float g_edgeDepth = 32.0;

PS_OUT ps_blur_normals( VS_OUTPUT In ) {

  float2 tc = In.vTexcoord; //+0.0*float2(0.5/g_windowWidth, 0.5/g_windowHeight);
  float4 depthCurrent = tex2D(smDepth, tc);
  if (depthCurrent.r > 0.999) {
    discard;
  }

  PS_OUT o = (PS_OUT)0;
  float4 result = 0;
  
  float2 d = float2(1.0/g_windowWidth, 1.0/g_windowHeight); // g_glowSize;
  d = g_glowSize;
  
  
 // float4 current = tex2D(smDiffuse, (In.vTexcoord-float2(0.5, 0.5))*g_glowCurrentDispTexCoordMul+float2(0.5, 0.5)+float2(0.5/g_windowWidth, 0.5/g_windowHeight));
  float4 current = unpack(tex2D(smDiffuse, tc));
  float4 origVal = current;
  
 // float angle = dot(current, g_glowCurrentDisp)+g_glowBaseAngle+(In.vTexcoord-float2(0.5, 0.5))*g_glowAngleTexCoordMul;
 // float2 sc = float2(sin(angle), cos(angle));
 // float2 sc = float2(0.0, 1.0);
  
    
  
  
  float dor = d.x;
  
  d *= (1.0*2.0/(depthCurrent.r));
  
  float2 vx = float2(d.x, 0.0);
  float2 vy = float2(0.0, d.y);
  
  float4 depthOther;
  float weight = 0.02;
  float thr = d.r*2.0;// *(1.0/depthCurrent.r); // 0.00020000;
  //float thr = 1.2*(1.0/depthCurrent.r); // 0.00020000;
  result += current*weight;
  
  float diff;
  float dd = 600.0; //g_edgeDepth;  
  //dd = 0.0;
  float bb = 1.0;
  float odw = 1.50;
  
  if (dor > 4.0/g_windowWidth) {
    //dd = 0.0;
	// odw = 0.0;
  }
  //dd = 0.0;
  depthOther = (tex2D(smDepth, tc+vy));
  diff = depthOther.g-depthCurrent.g;
  float smA = 0.0;
  float smB = 1.0;
  if (valueInThr(diff, thr)) {
	diff *= (1.0-smoothstep(smA, smB, abs(diff))); 
	result += unpack(tex2D(smDiffuse, tc+vy))*bb+float4(0.0, -diff, 0.0, 0.0)*dd;
	weight += 1.0;
  } else {
    result += float4(0.0, 1.0, 0.0, 0.0)*odw;
	weight += odw;
  }
  
  depthOther = (tex2D(smDepth, tc-vy));
  diff = depthOther.g-depthCurrent.g;
  if (valueInThr(diff, thr)) {
	diff *= (1.0-smoothstep(smA, smB, abs(diff))); 
	result += unpack(tex2D(smDiffuse, tc-vy))*bb+float4(0.0, diff, 0.0, 0.0)*dd;
	weight += 1.0;
  } else {
    result += float4(0.0, -1.0, 0.0, 0.0)*odw;
	weight += odw;
  }
  
  depthOther = (tex2D(smDepth, tc+vx));
  diff = depthOther.g-depthCurrent.g;
  if (valueInThr(diff, thr)) {
	diff *= (1.0-smoothstep(smA, smB, abs(diff))); 
    result += unpack(tex2D(smDiffuse, tc+vx))*bb+float4(-diff, 0.0, 0.0, 0.0)*dd;
	weight += 1.0;
  } else {
    result += float4(1.0, 0.0, 0.0, 0.0)*odw;
	weight += odw;
  }
  
  depthOther = (tex2D(smDepth, tc-vx));
  diff = depthOther.g-depthCurrent.g;
  if (valueInThr(diff, thr)) {
	diff *= (1.0-smoothstep(smA, smB, abs(diff))); 
    result += unpack(tex2D(smDiffuse, tc-vx))*bb+float4(diff, 0.0, 0.0, 0.0)*dd;
	weight += 1.0;
  } else {
    result += float4(-1.0, 0.0, 0.0, 0.0)*odw;
	weight += odw;
  }
  
  if (weight < 1.0) discard;
  
  result *= 1.0/(weight);
  result.zw = origVal.zw;
  result = pack(result);
 // result = normalize(result*2.0-1.0)*0.5+0.5;
  
  
  o.rt0 = result;
  return o;
}


PS_OUT ps_blur_line( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 result = 0;
  
  half2 d = g_glowSize;
  
  half4 current = tex2D(smDiffuseOrig, (In.vTexcoord-float2(0.5, 0.5))*g_glowCurrentDispTexCoordMul+float2(0.5, 0.5));
  
  half angle = dot(current, g_glowCurrentDisp)+g_glowBaseAngle+(In.vTexcoord-float2(0.5, 0.5))*g_glowAngleTexCoordMul;
  
  half2 sc = half2(sin(0.0+angle), cos(0.0+angle));
  
  half2 vx = half2(d.x*sc.y, d.x*sc.x);
  
  result += tex2D(smDiffuse, In.vTexcoord+vx);
  result += tex2D(smDiffuse, In.vTexcoord-vx);
    
  result *= 0.5;
  
  result *= 0.0+1.0*rand(In.vTexcoord).x;
  
  o.rt0 = result;
  return o;
}

PS_OUT ps_blur_god_rays( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 result = 0;
  
  float2 d = g_glowSize;
  

  result += tex2D(smDiffuse, In.vTexcoord*(d+1.0)+float2(-d.x, -d.y));
  result += tex2D(smDiffuse, In.vTexcoord*(d+1.0)+float2(d.x, -d.y));
  result += tex2D(smDiffuse, In.vTexcoord*(d+1.0)+float2(-d.x, d.y));
  result += tex2D(smDiffuse, In.vTexcoord*(d+1.0)+float2(d.x, d.y));

  result *= 0.25;
  
  o.rt0 = result;
  return o;
}




float g_glowExponent;
float g_glowLowLimit;
float g_glowPreMul;

PS_OUT ps_plain( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  float4 colorIn = clamp((tex2D(smDiffuse, In.vTexcoord)-g_glowLowLimit)*g_glowPreMul, 0.0, 10000.0);
  colorIn = pow(colorIn, g_glowExponent);
  o.rt0 = clamp(colorIn, 0.0, 10000.0);
  return o;
}

PS_OUT ps_blit( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  float4 colorIn = tex2D(smDiffuse, In.vTexcoord);
  o.rt0 = colorIn;
  return o;
}

float4 g_glowColor;

float g_glowAlpha = 1.0;

PS_OUT ps_glow_mix( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  float4 colorIn = tex2D(smDiffuse, In.vTexcoord);
  colorIn = colorIn*g_glowColor;
  colorIn.a = g_glowAlpha;
 // colorIn = colorIn*colorIn;
  o.rt0 = clamp(colorIn, 0.0, 10000.0);
  return o;
}




technique RenderBlurCross {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_aa( );
        PixelShader  = compile ps_3_0 ps_blur_cross( );
    }
}


technique RenderBlurGodRays {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_aa( );
        PixelShader  = compile ps_3_0 ps_blur_god_rays( );
    }
}



technique RenderBlurStream {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_aa( );
        PixelShader  = compile ps_3_0 ps_blur_stream( );
    }
}


technique RenderBlurBox {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_aa( );
        PixelShader  = compile ps_3_0 ps_blur_box( );
    }
}

technique RenderBlurLine {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_aa( );
        PixelShader  = compile ps_3_0 ps_blur_line( );
    }
}

technique RenderBlurNormals {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_aa( );
        PixelShader  = compile ps_3_0 ps_blur_normals( );
    }
}

technique RenderBlurNorm {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_aa( );
        PixelShader  = compile ps_3_0 ps_blur_norm( );
    }
}



technique RenderPlain {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_aa( );
        PixelShader  = compile ps_3_0 ps_plain( );
    }
}


technique RenderBlit {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_aa( );
        PixelShader  = compile ps_3_0 ps_blit( );
    }
}


technique RenderGlowMix {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_aa( );
        PixelShader  = compile ps_3_0 ps_glow_mix( );
    }
}





