
float4x4 g_mWorldViewProjection;    


float g_windowWidth;
float g_windowHeight;

float g_blur_strength;
float g_current_pixel_weight;

struct VS_INPUT {
    float4 vPosition : POSITION;
    float2 vTexcoord : TEXCOORD;
};

struct VS_OUTPUT {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vPosSS : TEXCOORD1;
};


VS_OUTPUT vs_dof( const VS_INPUT v ) {
  VS_OUTPUT o;
  
  o.vPosition = mul(v.vPosition, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
  
  o.vTexcoord = (v.vTexcoord)+float2(0.50/g_windowWidth, 0.50/g_windowHeight); 
  
  return o;
}


struct PS_OUT {
  float4 rt0 : COLOR0; // final mixed image
};

texture g_tDepth;
texture g_tNormal;
texture g_tDiffuse;

sampler smDepth =
sampler_state {
  Texture = <g_tDepth>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
  AddressU = BORDER;
  AddressV = BORDER;
};

sampler smNormal =
sampler_state {
  Texture = <g_tNormal>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;  
  AddressU = BORDER;
  AddressV = BORDER;
};

sampler smDiffuse =
sampler_state {
  Texture = <g_tDiffuse>;
  MipFilter = LINEAR;
  MinFilter = LINEAR; // POINT
  MagFilter = LINEAR; // LINEAR  
  AddressU = BORDER;
  AddressV = BORDER;
};


float g_focus;
float g_sharpDepth;
float g_frontAmp;
float g_backAmp;

float g_haloCorrectAmp;


const float zFar = 10000.0;
const float zNear = 0.10;


float getPointDist(float z) {
  float clipA = zFar / (zFar - zNear);
  float clipB = zFar*zNear / (zNear - zFar);
  return clipB/(z-clipA);  
}

float getPointZ(float d) {
  float clipA = zFar / (zFar - zNear);
  float clipB = zFar*zNear / (zNear - zFar);
  return (clipB + d*clipA)/d;
}

// d = cb/(z-ca); -> d*(z-ca) = cb; -> d*z -d*ca = cb -> z = (cb + d*ca)/d

float g_blur_loop=0.0;  // 0.0: first loop, 1.0: last loop

PS_OUT ps_dof( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 colorIn = tex2D(smDiffuse, In.vTexcoord);
  float4 od = tex2D(smDepth, In.vTexcoord);
  float4 result = 0;
  float at = g_current_pixel_weight;
  result = 1.0*colorIn*at;
  
  float frontStart = (clamp(g_focus-g_sharpDepth, 0.0, 100000.0)); 
  float backStart = (clamp(g_focus+g_sharpDepth, 0.0, 100000.0)); 
  
  float origDist = getPointDist(od.r);
  /*
  if (od.r > 0.999) {
   discard;
    //o.rt0 = colorIn;
	//return o;
  }
  */
  float ampBase = clamp((origDist-backStart)*g_backAmp*0.01, 0.0, 2.0);
  ampBase += clamp((frontStart-origDist)*g_frontAmp*0.01, 0.0, 2.0);
  
  //if (ampBase < 0.05) { // on sharp area
  //  discard;
  //}

  float mid = 0.5;
  for (int y=0; y<2; y++) {
    for (int x=0; x<2; x++) {
      float amp = ampBase*g_blur_strength;

    //  float2 po = In.vTexcoord+amp*(g_blur_strength)*float2((x-mid)/g_windowWidth, (y-mid)/g_windowHeight); //+float2(tcOfs/g_windowWidth, tcOfs/g_windowHeight);
      float2 po = In.vTexcoord+amp*float2((x-mid)/g_windowWidth, (y-mid)/g_windowHeight); //+float2(tcOfs/g_windowWidth, tcOfs/g_windowHeight);
	  
	  if (po.x > 1.0 || po.y > 1.0 || po.x < 0.0 || po.y < 0.0) {
	    continue;
	  }
	  
      float otherD = getPointDist(tex2D(smDepth, po));
      if (origDist > backStart) {
        amp *= clamp((otherD-backStart-(1.0-g_blur_loop)*g_haloCorrectAmp), 0.0, 1.0);
      }
	  if (origDist < frontStart) {
	    amp *= clamp(1.0-abs(otherD-origDist)*10.0, 0.0, 1.0);
	  }
	  po = In.vTexcoord+amp*float2((x-mid)/g_windowWidth, (y-mid)/g_windowHeight); //+float2(tcOfs/g_windowWidth, tcOfs/g_windowHeight);
     // po = In.vTexcoord+amp*(g_blur_strength)*float2((x-mid)/g_windowWidth, (y-mid)/g_windowHeight);
      // po = In.vTexcoord+amp*float2((x-mid)/g_windowWidth, (y-mid)/g_windowHeight);
      result += tex2D(smDiffuse, po)*amp;
      at += amp;
	  
	  float k=2.0;
      po = In.vTexcoord+k*(g_blur_strength)*float2((x-mid)/g_windowWidth, (y-mid)/g_windowHeight); //+float2(tcOfs/g_windowWidth, tcOfs/g_windowHeight);
      otherD = getPointDist(tex2D(smDepth, po));
	  if (otherD < frontStart) {
	    amp = clamp(abs((otherD-frontStart)*(otherD-frontStart))*0.0150*g_frontAmp, 0.0, 1.0);
	  } else {
	    amp = 0.0;
	  }
      po = In.vTexcoord+amp*k*(g_blur_strength)*float2((x-mid)/g_windowWidth, (y-mid)/g_windowHeight); //+float2(tcOfs/g_windowWidth, tcOfs/g_windowHeight);
      otherD = getPointDist(tex2D(smDepth, po));
	  if (otherD < frontStart) {
	    amp = clamp(abs((otherD-frontStart)*(otherD-frontStart))*0.010*g_frontAmp, 0.0, 1.0);
	  } else {
	    amp = 0.0;
      }	 
      po = In.vTexcoord+amp*k*(g_blur_strength)*float2((x-mid)/g_windowWidth, (y-mid)/g_windowHeight);
	  amp*=5.0;
      result += tex2D(smDiffuse, po)*amp;
      at += amp;	
	  
 
 //     atB += at;
    }
  }
 // result = 1.0*result/at*1.0;
  
 // at = 0.0001;
 /*
  mid = 1.0;
  float4 rFront = float4(0.0, 0.0, 0.0, 0.0);
  for (int y=0; y<3; y++) {
    for (int x=0; x<3; x++) {
	  float amp=0.0;
	  float k=8.0;
      float2 po = In.vTexcoord+g_blurLoop*k*(g_blur_strength)*float2((x-mid)/g_windowWidth, (y-mid)/g_windowHeight); //+float2(tcOfs/g_windowWidth, tcOfs/g_windowHeight);
      float otherD = getPointDist(tex2D(smDepth, po));
	  if (otherD < frontStart) {
	    amp = clamp(abs(otherD-frontStart)*0.0150*g_frontAmp, 0.0, 1.0);
	  }
	  
      po = In.vTexcoord+g_blurLoop*amp*k*(g_blur_strength)*float2((x-mid)/g_windowWidth, (y-mid)/g_windowHeight); //+float2(tcOfs/g_windowWidth, tcOfs/g_windowHeight);
      otherD = getPointDist(tex2D(smDepth, po));
	  if (otherD < frontStart) {
	    amp = 1.0*clamp(abs(otherD-frontStart)*0.010*g_frontAmp, 0.0, 1.0);
	  } else {
	    amp=0.0;
      }	 
      po = In.vTexcoord+g_blurLoop*amp*k*(g_blur_strength)*float2((x-mid)/g_windowWidth, (y-mid)/g_windowHeight);
	  amp*=1.0;
      result += tex2D(smDiffuse, po)*amp;
      at += amp;
    }
  }
  */
 // result = result*atB/(at+atB)+rFront/at*at/(at+atB);
  result = result/at*1.0;
  result.w = 1.0;
  
 
  o.rt0 = result;
  return o;
}

technique Render {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_dof( );
        PixelShader  = compile ps_3_0 ps_dof( );
    }
}

