
float4x4 g_mWorldViewProjection;    
float4x4 g_mWorld;
float4x4 g_mView;

float g_windowWidth;
float g_windowHeight;
float g_time;

struct VS_INPUT_INSTANCED {
    float4 vPosition : POSITION;
    float3 vNormal : NORMAL;
    float2 vTexcoord : TEXCOORD0;
    float4 vWHI : TEXCOORD1;
    float3 vTangent : TANGENT;
    float3 vBiNormal : BINORMAL;
};

struct VS_OUTPUT {
    float4  vPosition : POSITION;
	float2  vTexcoord : TEXCOORD0;
    float4  vPosSS : TEXCOORD1;
    float4  vPosSO : TEXCOORD2;
};


texture g_tPosition;
sampler DisplaceSampler = sampler_state
{
texture = <g_tPosition>;
MinFilter = POINT;
MagFilter = POINT;
MipFilter = NONE;
AddressU = CLAMP;
AddressV = CLAMP;
};

float4 g_meshSize;
float g_scale = 1.0;

VS_OUTPUT vs( const VS_INPUT_INSTANCED v ) {
  VS_OUTPUT o;
  
  float4 vPosTrans = v.vPosition*(float4(1.0, 1.0, 1.0, 0.0)*g_scale+float4(0.0, 0.0, 0.0, 1.0));
   
  float4 mSS = mul(vPosTrans, g_mWorldViewProjection);
  float4 pulkka = (tex2Dlod(DisplaceSampler, float4(v.vWHI.x+0.5/g_windowWidth, v.vWHI.y+0.5/g_windowHeight, 0, 0)));
  pulkka.w = 0.0;

  pulkka.x /= g_meshSize.x;
  pulkka.y /= g_meshSize.y;
  pulkka.z /= g_meshSize.z;
  vPosTrans += pulkka;
  
  o.vPosition = mul(vPosTrans, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
  
  o.vTexcoord = (o.vPosition+1.0)*0.5+float2(0.5/g_windowWidth, 0.5/g_windowHeight);
  
  float4 possex = mul(vPosTrans, g_mWorld);
  o.vPosSO = mul(possex, g_mView);
  return o;
}



texture g_tDepth;
sampler smDepth =
sampler_state {
  Texture = <g_tDepth>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
  AddressU = BORDER;
  AddressV = BORDER;
};

texture g_tNormal;
sampler smNormal =
sampler_state {
  Texture = <g_tNormal>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;  
  AddressU = BORDER;
  AddressV = BORDER;
};

texture g_tDiffuse;
sampler smDiffuse =
sampler_state {
  Texture = <g_tDiffuse>;
  MipFilter = LINEAR; // ANISOTROPIC, LINEAR, POINT, PYRAMIDALQUAD, GAUSSIANQUAD
  MinFilter = LINEAR;
  MagFilter = LINEAR;  
  AddressU = WRAP;
  AddressV = WRAP;
};

texture g_tAmbSpec;
sampler smAmbSpec =
sampler_state {
  Texture = <g_tAmbSpec>;
  MipFilter = POINT;
  MinFilter = POINT;
  MagFilter = POINT;
  AddressU = BORDER;
  AddressV = BORDER;
};


float3 getNormal3(float2 n) {
  float3 n3;
  n3.xy = n*2.0-1.0;
  n3.z = sqrt(1.0-n3.x*n3.x-n3.y*n3.y);
  return n3;
}
//getNormal3(tex2D(smNormal, rayTexC).xy)*2.0-1.0  

struct PS_OUT {
  float4 rt0 : COLOR0;
};

PS_OUT ps( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 lightResult = (float4)0;
  float4 result = (float4)0.0;

  float4 lightViewPos;
   
  float4 depthV = tex2D(smDepth, In.vTexcoord);

  if (depthV.r > 0.99999) {
  //  lightResult.a = 1.0;
  //  lightResult.r = 1.0;
    o.rt0 = lightResult;
    return o;
  }
  
  /*
  
  float clipA = zFar / (zFar - zNear);
  float clipB = zFar*zNear / (zNear - zFar);
  float pointDist = clipB/(depthV.r-clipA);
  
  float pointDist2 = pointDist*pointDist;
  float4 pointV = float4(In.vPosSS.x*g_windowWidth/g_windowHeight, In.vPosSS.y, 1.0, 0.0)*pointDist;
  
  float4 pointVN = normalize(pointV);
    
  // render lightball
  
  lightViewPos = mul(g_lightPos, g_mView);

  float2 texus = (In.vTexcoordActual-0.5)*2.0;
  float lightCover = clamp((3.0-dot(texus, texus)*3.0)*1.0, 0.0, 1.0);
 // lightResult *= lightCover;
  

  float4 diffuseV = tex2D(smDiffuse, In.vTexcoord);
  diffuseV.a = 1.0;
  
  float4 ambSpec = tex2D(smAmbSpec, In.vTexcoord);
  

  float4 normalV = float4(getNormal3(tex2D(smNormal, In.vTexcoord).xy), 0.0);
  
  diffuseV *= diffuseV;  
	
//  lightViewPos = mul(g_lightPos, g_mView);
  
  float4 lightToPoint = lightViewPos-pointV;
  float lightToPointDist2 = dot(lightToPoint, lightToPoint);

  float4 ambienssi = tex2D(smAO, In.vTexcoord).r;
  ambienssi = pow(clamp(1.0-ambienssi, 0.0, 1.0), g_ao_pow);
	
  ambienssi*=ambienssi;
	

  float lightToPointAtt = saturate(1.0-0.005*g_lightInvDistance*g_lightInvDistance*lightToPointDist2);

  // diffuse
  float lightToPointDist = sqrt(lightToPointDist2);
  float normalLightDot = dot(normalV, lightToPoint/(lightToPointDist+1.0));
  normalLightDot = clamp(normalLightDot, 0.0, 100.0);
  normalLightDot = pow(normalLightDot, 1.0)*16.0*lightToPointAtt-0.01;
  normalLightDot = clamp(normalLightDot, 0.0, 10000.0)*lightCover;
  result += (normalLightDot*g_lightColor*g_lightColor)*diffuseV*ambienssi;
 // result += (normalLightDot*g_lightColor)*diffuseV*ambienssi;
  
  // specular reflection
  float3 reflected = reflect(float3(lightToPoint.xyz), normalize(float3(normalV.xyz)));
  float specularDot = dot(reflected, float3(pointVN.xyz))/(lightToPointDist+1.0);
  specularDot = clamp(specularDot*1.0, 0.0, 100.0);
  specularDot = pow(specularDot, ambSpec.z)*ambSpec.y*1.0*lightToPointAtt; // pow(specularDot, g_specularExponent*(ambSpec.y*1.0+1.0))*ambSpec.y*16000.0/(lightToPointDist2*g_lightInvDistance+1.0)-0.01;
  specularDot = clamp(specularDot, 0.0, 10000.0)*lightCover*ambienssi;
  result += specularDot*g_lightColor*g_lightColor*1.0;
 // result += specularDot*g_lightColor*1.0;
  
  result += lightResult;
  result.a = diffuseV.w;
  
  */
  result.r = 1.0;
  result.a = 1.0;
  
  o.rt0 = result;
  return o;
}




technique Render {
    pass P0 {          
        VertexShader = compile vs_3_0 vs( );
        PixelShader  = compile ps_3_0 ps( );
    }
}



