#version 120

varying vec3 n;
varying vec3 wn;

uniform vec3 lightdir=vec3(-1.,-1.,1.);
uniform vec4 lightcolor=vec4(1.,.7,.5,1.);

void main() {
	vec3 normal=normalize(wn);
	float lightdot = max(0.,dot(normal,normalize(lightdir)));
	
	float glenz = pow(lightdot,4);
	vec3 c = lightcolor.xyz*glenz + lightcolor.a*lightdot;
	
	gl_FragColor = vec4(0.,0.,0.,1.);
	gl_FragColor.xyz = c;
}
