#version 130

varying vec3 n;
varying vec3 wn;
varying vec3 wc;
uniform vec2 r; 
uniform float waveheight=0.;
uniform float wavewidth=0.;
uniform float wavepos=0.;
uniform float t=0.;

void main(void) {
   wc = gl_Vertex.xyz;
   gl_Position = ftransform();
   vec3 p = wc.xyz;
   float coord = (p.x-wavepos)/wavewidth;
   float wave = waveheight * exp(-coord*coord);
   gl_Position.z += wave;
   n=normalize(gl_NormalMatrix*gl_Normal);
   wn=normalize(gl_Normal);
}