#version 130

varying vec3 n;
varying vec3 wn;
varying vec3 wc;
uniform vec2 r; 
uniform float id_wobble=0.;
uniform float wobble=0.;
uniform float wobble_freq=10.;
uniform float t=0.;

float pn(vec3 p) {
        p *= 1.5;
        vec3 i = floor(p);
        vec4 a = dot(i, vec3(1,57,21)) + vec4(0,57,21,78);
        vec3 f = cos((p-i)*acos(-1.))*(-.5) + .5;
        a = mix(sin(cos(a)*a), sin(cos(1+a)*(1+a)), f.x);
        a.xy = mix(a.xz, a.yw, f.y);
        return mix(a.x, a.y, f.z);
}

float fpn(vec3 p) {
   float r;
   p.xz = cos(1.) * p.xz + vec2(-sin(1.), sin(1.)) * p.zx;
   r = pn(p*.06125)*.5;
   p.xy = cos(1.) * p.xy + vec2(-sin(1.), sin(1.)) * p.yx;
   r += pn(p*.125)*.25;
   p.zy = cos(1.) * p.zy + vec2(-sin(1.), sin(1.)) * p.yz;
   r += pn(p*.25)*.125;
   return r;
}

void main(void) {
	wc = gl_Vertex.xyz;
   gl_Position = ftransform();
   float time=t*wobble_freq;
   vec3 p = 3.*gl_Position.xyz;
   float id = id_wobble * sin(gl_VertexID);
   vec3 dp=vec3(fpn(p+vec3(time,-time,2+id)),fpn(p+vec3(4,5+time,6-time-3*id)),0);
   gl_Position.xyz += wobble*dp;
   n=normalize(gl_NormalMatrix*gl_Normal);
   wn=normalize(gl_Normal);
   gl_TexCoord[0] = gl_MultiTexCoord0;
}