#version 430
#if 1
#define extern uniform
#define Image sampler2D
#endif

layout (binding=0) uniform sampler2D input;
in vec2 texcoord;
layout (location=0) out vec4 out0;

layout (location=1) uniform vec2 r;
layout (location=2) uniform float t;
layout (location=3) uniform float amount=1.;
layout (location=4) uniform vec2 tex_shift=vec2(0.);
layout (location=5) uniform float tex_rotate=0.;
layout (location=6) uniform float zoom=1.;
layout (location=7) uniform float schwurbel=0.;
layout (location=500) uniform float time=0.;

float pn(vec3 p) {
        p *= 1.5;
        vec3 i = floor(p);
        vec4 a = dot(i, vec3(1,57,21)) + vec4(0,57,21,78);
        vec3 f = cos((p-i)*acos(-1.))*(-.5) + .5;
        a = mix(sin(cos(a)*a), sin(cos(1+a)*(1+a)), f.x);
        a.xy = mix(a.xz, a.yw, f.y);
        return mix(a.x, a.y, f.z);
}

float fpn(vec3 p) {
   float r;
   p.xz = cos(1.) * p.xz + vec2(-sin(1.), sin(1.)) * p.zx;
   r = pn(p*.06125)*.5;
   p.xy = cos(1.) * p.xy + vec2(-sin(1.), sin(1.)) * p.yx;
   r += pn(p*.125)*.25;
   p.zy = cos(1.) * p.zy + vec2(-sin(1.), sin(1.)) * p.yz;
   r += pn(p*.25)*.125;
   return r;
}

void main() {
	float s=sin(tex_rotate);
	float c=cos(tex_rotate);
	vec2 tc=zoom*vec2(c*texcoord.x + s*texcoord.y, -s*texcoord.x + c*texcoord.y);
	
	tc += schwurbel * vec2(fpn(vec3(25*tc.x,25*tc.y,time)),fpn(vec3(-25*tc.y,25*tc.x,-time)));
	
	vec4 intex = texture(input,tc+tex_shift);
	intex.xyz *= amount;
	out0 = intex;
}
