/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;
import sun.security.util.Debug;

public final class AccessController {
    private AccessController() {
    }

    @CallerSensitive
    public static native <T> T doPrivileged(PrivilegedAction<T> var0);

    @CallerSensitive
    public static <T> T doPrivilegedWithCombiner(PrivilegedAction<T> privilegedAction) {
        AccessControlContext accessControlContext = AccessController.getStackAccessControlContext();
        if (accessControlContext == null) {
            return AccessController.doPrivileged(privilegedAction);
        }
        DomainCombiner domainCombiner = accessControlContext.getAssignedCombiner();
        return AccessController.doPrivileged(privilegedAction, AccessController.preserveCombiner(domainCombiner, Reflection.getCallerClass()));
    }

    @CallerSensitive
    public static native <T> T doPrivileged(PrivilegedAction<T> var0, AccessControlContext var1);

    @CallerSensitive
    public static <T> T doPrivileged(PrivilegedAction<T> privilegedAction, AccessControlContext accessControlContext, Permission ... permissionArray) {
        AccessControlContext accessControlContext2 = AccessController.getContext();
        if (permissionArray == null) {
            throw new NullPointerException("null permissions parameter");
        }
        Class<?> clazz = Reflection.getCallerClass();
        return AccessController.doPrivileged(privilegedAction, AccessController.createWrapper(null, clazz, accessControlContext2, accessControlContext, permissionArray));
    }

    @CallerSensitive
    public static <T> T doPrivilegedWithCombiner(PrivilegedAction<T> privilegedAction, AccessControlContext accessControlContext, Permission ... permissionArray) {
        AccessControlContext accessControlContext2 = AccessController.getContext();
        DomainCombiner domainCombiner = accessControlContext2.getCombiner();
        if (domainCombiner == null && accessControlContext != null) {
            domainCombiner = accessControlContext.getCombiner();
        }
        if (permissionArray == null) {
            throw new NullPointerException("null permissions parameter");
        }
        Class<?> clazz = Reflection.getCallerClass();
        return AccessController.doPrivileged(privilegedAction, AccessController.createWrapper(domainCombiner, clazz, accessControlContext2, accessControlContext, permissionArray));
    }

    @CallerSensitive
    public static native <T> T doPrivileged(PrivilegedExceptionAction<T> var0) throws PrivilegedActionException;

    @CallerSensitive
    public static <T> T doPrivilegedWithCombiner(PrivilegedExceptionAction<T> privilegedExceptionAction) throws PrivilegedActionException {
        AccessControlContext accessControlContext = AccessController.getStackAccessControlContext();
        if (accessControlContext == null) {
            return AccessController.doPrivileged(privilegedExceptionAction);
        }
        DomainCombiner domainCombiner = accessControlContext.getAssignedCombiner();
        return AccessController.doPrivileged(privilegedExceptionAction, AccessController.preserveCombiner(domainCombiner, Reflection.getCallerClass()));
    }

    private static AccessControlContext preserveCombiner(DomainCombiner domainCombiner, Class<?> clazz) {
        return AccessController.createWrapper(domainCombiner, clazz, null, null, null);
    }

    private static AccessControlContext createWrapper(DomainCombiner domainCombiner, Class<?> clazz, AccessControlContext accessControlContext, AccessControlContext accessControlContext2, Permission[] permissionArray) {
        ProtectionDomain protectionDomain = AccessController.getCallerPD(clazz);
        if (accessControlContext2 != null && !accessControlContext2.isAuthorized() && System.getSecurityManager() != null && !protectionDomain.impliesCreateAccessControlContext()) {
            ProtectionDomain protectionDomain2 = new ProtectionDomain(null, null);
            return new AccessControlContext(new ProtectionDomain[]{protectionDomain2});
        }
        return new AccessControlContext(protectionDomain, domainCombiner, accessControlContext, accessControlContext2, permissionArray);
    }

    private static ProtectionDomain getCallerPD(final Class<?> clazz) {
        ProtectionDomain protectionDomain = AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

            @Override
            public ProtectionDomain run() {
                return clazz.getProtectionDomain();
            }
        });
        return protectionDomain;
    }

    @CallerSensitive
    public static native <T> T doPrivileged(PrivilegedExceptionAction<T> var0, AccessControlContext var1) throws PrivilegedActionException;

    @CallerSensitive
    public static <T> T doPrivileged(PrivilegedExceptionAction<T> privilegedExceptionAction, AccessControlContext accessControlContext, Permission ... permissionArray) throws PrivilegedActionException {
        AccessControlContext accessControlContext2 = AccessController.getContext();
        if (permissionArray == null) {
            throw new NullPointerException("null permissions parameter");
        }
        Class<?> clazz = Reflection.getCallerClass();
        return AccessController.doPrivileged(privilegedExceptionAction, AccessController.createWrapper(null, clazz, accessControlContext2, accessControlContext, permissionArray));
    }

    @CallerSensitive
    public static <T> T doPrivilegedWithCombiner(PrivilegedExceptionAction<T> privilegedExceptionAction, AccessControlContext accessControlContext, Permission ... permissionArray) throws PrivilegedActionException {
        AccessControlContext accessControlContext2 = AccessController.getContext();
        DomainCombiner domainCombiner = accessControlContext2.getCombiner();
        if (domainCombiner == null && accessControlContext != null) {
            domainCombiner = accessControlContext.getCombiner();
        }
        if (permissionArray == null) {
            throw new NullPointerException("null permissions parameter");
        }
        Class<?> clazz = Reflection.getCallerClass();
        return AccessController.doPrivileged(privilegedExceptionAction, AccessController.createWrapper(domainCombiner, clazz, accessControlContext2, accessControlContext, permissionArray));
    }

    private static native AccessControlContext getStackAccessControlContext();

    static native AccessControlContext getInheritedAccessControlContext();

    public static AccessControlContext getContext() {
        AccessControlContext accessControlContext = AccessController.getStackAccessControlContext();
        if (accessControlContext == null) {
            return new AccessControlContext(null, true);
        }
        return accessControlContext.optimize();
    }

    public static void checkPermission(Permission permission) throws AccessControlException {
        if (permission == null) {
            throw new NullPointerException("permission can't be null");
        }
        AccessControlContext accessControlContext = AccessController.getStackAccessControlContext();
        if (accessControlContext == null) {
            Debug debug = AccessControlContext.getDebug();
            boolean bl = false;
            if (debug != null) {
                bl = !Debug.isOn("codebase=");
                bl &= !Debug.isOn("permission=") || Debug.isOn("permission=" + permission.getClass().getCanonicalName());
            }
            if (bl && Debug.isOn("stack")) {
                Thread.dumpStack();
            }
            if (bl && Debug.isOn("domain")) {
                debug.println("domain (context is null)");
            }
            if (bl) {
                debug.println("access allowed " + permission);
            }
            return;
        }
        AccessControlContext accessControlContext2 = accessControlContext.optimize();
        accessControlContext2.checkPermission(permission);
    }
}

