(function(demo){
	var scene = new DemoScene(demo);
	
	scene.duration = 4;
	scene.scene = new THREE.Scene();
	
	var camera = new THREE.PerspectiveCamera(85, demo.settings.viewport.aspect, 1, 4000),
		texts = [
			'The',
			'Funky',
			'Ice',
			'Cream',
			'Machine'
		],
		material = new THREE.MeshLambertMaterial(
			{
				color: 0xffffff,
				wireframe: false
			}),
		light = new THREE.SpotLight( 0xffffff, 1.5 ),
		light2 = new THREE.AmbientLight(0x110022),
		meshArray = [];
	
	
	for(var i = texts.length; i--;){
		var geometry = new THREE.TextGeometry(texts[i], {
				size: 200,
				height: 20,
				curveSegments: 6,
				font: 'helvetiker',
				weight: 'normal',
				material: 0,
				extrudeMaterial: 1
			}),
			instance = new THREE.Mesh(geometry, material);
		
		instance.castShadow = true;
		instance.receiveShadow = true;
		instance.position.y = i * -230;
		
		meshArray.push(instance);
		scene.scene.add(instance);
	}
	
	
	camera.position.x = 800;
	camera.position.z = 1000;
	camera.position.y = -400;
	scene.camera = camera;
	
	
	light.castShadow = true;
	
	light.shadowCameraNear = 300;
	light.shadowCameraFar = camera.far;
	light.shadowCameraFov = 50;
	
	light.shadowBias = -0.00022;
	light.shadowDarkness = 0.9;
	
	light.shadowMapWidth = 1024;
	light.shadowMapHeight = 1024;
	
	
	
	
	scene.scene.add(camera);
	scene.scene.add(light);
	scene.scene.add(light2);
	
	
	scene.update = function(){
		var sceneTime = (this.demo.timing.elapsed - this.startTime);
		
		for(var i = meshArray.length; i--;){
			meshArray[i].scale.z = 2 + Math.sin((sceneTime + i * 140) / 140) * 1.8;
			meshArray[i].rotation.x = Math.sin((sceneTime + i * 140) / 600) * 0.18;
		}
		
		camera.rotation.x = Math.sin(sceneTime / 1400) * 0.18;
		camera.rotation.y = Math.sin(sceneTime / 1400) * 0.28;
		camera.rotation.z = Math.sin(sceneTime / 1400) * 0.48;
		
		light.position.x = Math.sin(sceneTime / 1400) * 200 + 3200;
		light.position.y = Math.sin(sceneTime / 2400) * 400 + 300;
		light.position.z = Math.sin(sceneTime / 800) * 300 + 600;
	};
	
	demo.pushScene(scene);
})(demo);