(function(demo){
	var scene = new DemoScene(demo);
	
	scene.duration = 8;
	scene.scene = new THREE.Scene();
	
	var camera = new THREE.PerspectiveCamera(85, demo.settings.viewport.aspect, 1, 4000),
		geometry = new THREE.TorusGeometry(100, 30, 8, 24, Math.PI*2),
		material = new THREE.MeshLambertMaterial(
			{
				color: 0xffffff,
				wireframe: false
			}),
		light = new THREE.SpotLight( 0xffffff, 1.5 ),
		light2 = new THREE.AmbientLight(0x110022),
		meshArray = [];
	
	
	demo.cache.set('geometry', 'torus100', geometry);
	demo.cache.set('material', 'lambert_white', material);
	
	for(var z = -10; z < 10; z++){
		for(var x = -10; x < 10; x++){
			var instance = new THREE.Mesh(geometry, material);
			instance.position.x = (.5 - Math.random()) * 2600;
			instance.position.y = (.5 - Math.random()) * 2600 - 400;
			instance.position.z = (.5 - Math.random()) * 2600 + 400;
			
			instance.rotation.x = (.5 - Math.random()) * 60;
			instance.rotation.y = (.5 - Math.random()) * 60;
			instance.rotation.z = (.5 - Math.random()) * 60;
			
			instance.castShadow = true;
			instance.receiveShadow = true;
			
			meshArray.push(instance);
			scene.scene.add(instance);
		}
	}
	
	
	scene.camera = camera;
	
	
	
	light.castShadow = true;
	
	light.shadowCameraNear = 300;
	light.shadowCameraFar = camera.far;
	light.shadowCameraFov = 50;
	
	light.shadowBias = -0.00022;
	light.shadowDarkness = 0.9;
	
	light.shadowMapWidth = 1024;
	light.shadowMapHeight = 1024;
	
	
	
	
	scene.scene.add(camera);
	scene.scene.add(light);
	scene.scene.add(light2);
	
	
	scene.update = function(){
		var sceneTime = (this.demo.timing.elapsed - this.startTime);
		
		for(var i = meshArray.length; i--;){
			meshArray[i].scale.z = 1 + Math.sin((sceneTime + i * 140) / 460) * 0.2;
		}
		
		camera.position.x = Math.sin(sceneTime / 3400) * 100;
		camera.position.y = Math.cos((sceneTime + 4000) / 3400) * 100;
		camera.position.z = Math.sin((sceneTime  + 4900) / 3000) * 40;
		
		camera.rotation.x = sceneTime / 1400 * 0.18;
		camera.rotation.y = Math.sin(sceneTime / 1400) * 0.28;
		camera.rotation.z = Math.sin(sceneTime / 1400) * 0.48;
		
		light.position.x = Math.sin(sceneTime / 1400) * 400;
		light.position.y = Math.sin(sceneTime / 2400) * 400;
		light.position.z = Math.sin(sceneTime / 800) * 200;
	};
	
	demo.pushScene(scene);
})(demo);