(function(demo){
	var scene = new DemoScene(demo);
	
	scene.duration = 8;
	scene.scene = new THREE.Scene();
	
	var camera = new THREE.PerspectiveCamera(85, demo.settings.viewport.aspect, 1, 1000),
		geometry = new THREE.TextGeometry('TFICM',
			{
				size: 200,
				height: 20,
				curveSegments: 6,
				font: 'helvetiker',
				weight: 'normal',
				material: 0,
				extrudeMaterial: 1
			}),
		material = demo.cache.get('material', 'phong_white'),
		mesh = new THREE.Mesh(geometry, material),
		light = new THREE.PointLight(0xffffff, 1, 1000),
		light2 = new THREE.AmbientLight(0x110022);
	
	
	demo.cache.set('geometry', 'text_tficm', geometry);
	demo.cache.set('mesh', 'text_tficm_phong_white', mesh);
	
	
	camera.position.z = -10;
	camera.position.y = 100;
	camera.position.x = 430;
	
	scene.camera = camera;
	
	light.position.set(0, -50, 250);
	
	
	scene.scene.add(camera);
	scene.scene.add(mesh);
	scene.scene.add(light);
	scene.scene.add(light2);
	
	scene.update = function(){
		var sceneTime = (this.demo.timing.elapsed - this.startTime);
		
		mesh.rotation.x = (sceneTime / 160) * 0.01;
		mesh.rotation.y = (sceneTime / 180) * 0.01;
		
		if(camera.position.z < 830){
			camera.position.z = 830 - Math.ceil((830 - camera.position.z) / 1.003);
		}
		
		camera.position.x = Math.sin(sceneTime / 2400) * 300 + 430;
	};
	
	demo.pushScene(scene);
})(demo);