    MAC MASS_LOGIC
MassGfx
    byte %00111111
    byte %00100001
    byte %00100001
    byte %01100001
    byte %10100001
    byte %10100001
    byte %01100001
    byte %00100001

BeerAnim
    byte %00011111
    byte %00011111
    byte %00011111
    byte %00000000

    byte %00011111
    byte %00011111
    byte %00011111
    byte %00000001

    byte %00011111
    byte %00011111
    byte %00001111
    byte %00000011

    byte %00011111
    byte %00001111
    byte %00001111
    byte %00000111

massLogic
    lda beat
    bne NoReset
    lda tempoCount
    bpl NoReset
    lda #40
    sta frame
NoReset
    ;load beer graphics - slosh for last couple of frames
    lda frame
    and #$7F
    sec
    sbc #64
    bmi LoadFrame0
    cmp #32
    bcc SloshForward

    ;slosh backward
    sta temp+1
    lda #63
    sbc temp+1       ;C=1
    bpl SloshForward
LoadFrame0
    lda #0
SloshForward
    asr #%11111000
    tax
    ldy #0
LoadBeerLoop
    lda BeerAnim,X
    sta beergfx+0,Y
    inx
    iny
    cpy #4
    bne LoadBeerLoop

    lda #0
    ldx #3
ClearBeerLoop
    sta beergfx+4,X
    dex
    bpl ClearBeerLoop

    ;horizontal offset
    lda frame
    asr #$7F
    cmp #32
    bcc Clamped32
    lda #32
Clamped32
    sta temp+1
    lsr
    lsr
    beq MassShiftLoopEnd
    ;shift graphics right 1-8 pixels
    tay
MassShiftLoop
    ldx #3
MassShiftInnerLoop
    lsr beergfx+0,X
    rol beergfx+4,X
    dex
    bpl MassShiftInnerLoop
    dey
    bne MassShiftLoop
MassShiftLoopEnd

    ;position sprites
    lda temp+1
    clc
    adc #20
    ldx #0
    stx VDELP0
    stx VDELP1
    jsr PositionObject
    lda #115
    sec
    sbc temp+1
    inx
    jsr PositionObject
    sta WSYNC
    sta HMOVE
    ldx #8
    stx REFP1
    dex
    stx NUSIZ0
    stx NUSIZ1
    lda #1
    sta CTRLPF
    lda #$2E
    sta COLUPF
    lda #$0E
    sta COLUP0
    sta COLUP1
    rts
    ENDM

    MAC MASS_KERNEL
massKernel
    ldx #(LINES-64)/2
MassKernelBurn1
    sta WSYNC
    dex
    bne MassKernelBurn1

    ldx #31
MassKernelLoop
    txa
    lsr
    lsr
    tay
    sta WSYNC
    lda MassGfx,Y
    sta GRP0
    sta GRP1

    txa
    lsr
    asr #%00011110
    sbc #3
    tay
    bpl YOK
    ldy #0
YOK
    lda beergfx+0,Y
    sta PF1
    lda beergfx+4,Y
    sta PF2

    sta WSYNC
    dex
    bpl MassKernelLoop

    ldx #(LINES-63)/2-1
MassKernelBurn2
    sta WSYNC
    lda #0
    sta GRP0
    sta GRP1
    sta PF1
    sta PF2
    sta REFP1
    dex
    bne MassKernelBurn2
    rts
    ENDM
