#define maxlines 2048
#define maxtiles 4096

#ifdef MAIN
	#define EXTERN
	long frameplace = 0x000a0000;
#else
	#define EXTERN extern
	extern frameplace;
#endif

EXTERN short int xdim, ydim;
EXTERN long posx, posy, posz;
EXTERN short int ang;
EXTERN volatile char keystatus[256];
EXTERN brightenarea;
EXTERN short int umost[321], dmost[321];
EXTERN short int sintable[2048];
EXTERN long clockspeed, totalclock, numframes;
EXTERN long vel, svel, hvel, angvel, newposz;
/*

POSITION VARIABLES:

		POSX is your x - position ranging from 0 to 65535
		POSY is your y - position ranging from 0 to 65535
			(the length of a side of the grid in EDITBORD would be 1024)
		POSZ is your z - position (height) ranging from 0 to 65535, 0 highest.
		ANG is your angle ranging from 0 to 2047.  Instead of 360 degrees, or
			 2 * PI radians, I use 2048 different angles, so 90 degrees would
			 be 512 in my system.

KEYBOARD READING (KEYSTATUS):

		- Up / Down status of all keys on keyboard
		For example, keystatus[1] happens to be the state of the ESCAPE KEY

		if keystatus[1] = 0 then the escape key is not pressed while
		if keystatus[1] > 0 then the esacpe key is pressed

		This is good for checking if multiple keys are pressed at the same time.
		One disadvantage of this method of reading the keyboard is that the
	keystatus[x] stays > 0 until you release the key.  If you want to be
	certain that whatever is done once when the key is pressed once, you
	may want to set keystatus[x] = 0 right after you sense
	keystatus[x] > 0.

BRIGHTENAREA:

		- for special effects such as a gun shooting.
		A value from 0 to around 9.
		0 is normal, the higher the number, the brighter.

OTHER VARIABLES:

		UMOST[320] is an array of the highest y-coordinates on each column that
				my engine is allowed to write to.
		DMOST[320] is an array of the lowest y-coordinates on each column that
				my engine is allowed to write to.
			If you call drawscreen with first parameter a 1, then you MUST
				initialize UMOST and DMOST before calling it.
		SINTABLE[2048] is a sin table with 2048 angles rather than the
			normal 360 angles for higher precision.  Also since SINTABLE is in
			all integers, the range is multiplied by 16383, so instead of the
			normal -1<sin(x)<1, the range of sintable is -16383<sintable[]<16383
			If you use this sintable, you can possibly speed up your code as
			well as save space in memory.  If you plan to use sintable, 2
			identities you may want to keep in mind are:
				sintable[ang&2047]       = sin(ang * (3.141592/1024)) * 16383
				sintable[(ang+512)&2047] = cos(ang * (3.141592/1024)) * 16383

*/
