
struct VS_OUTPUT
{
  float4 Position: POSITION;
  float3 Tex0:     TEXCOORD0;
  float3 Tex1:     TEXCOORD1;
};

sampler Sampler = sampler_state
{
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
};

sampler SamplerNoise = sampler_state
{
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
};


float V_Alpha : ALPHA;
float V_Var1 : VAR1;
float V_Rand1 : RAND1;
float V_Rand2 : RAND2;
float4 PS(VS_OUTPUT In) : COLOR0
{
	float2 nzoom=float2(8,6);
	float nois=tex2D(SamplerNoise, (In.Tex1+float2(V_Rand1,V_Rand2))*nzoom)+tex2D(SamplerNoise, (In.Tex1+float2(V_Rand2,V_Rand1))*nzoom*0.66)+tex2D(SamplerNoise, (In.Tex1+float2(V_Rand2,V_Rand1))*nzoom*0.33);
	float4 color = tex2D(Sampler,(In.Tex0-0.5)*(nois*V_Var1+1-V_Var1)+0.5);
	color=color*(1-V_Var1)+0.333*nois*V_Var1;
	color.a= V_Alpha;
	return color;
}

technique Deform
{
  pass PassDeform
  {
    PixelShader = compile ps_2_0 PS();
  }
}
